/*
 * Decompiled with CFR 0.152.
 */
package com.narvee.serviceimpl;

import com.narvee.dto.AppliedListDTO;
import com.narvee.dto.ConsultantDTO;
import com.narvee.dto.ConsultantReportDTO;
import com.narvee.dto.DateSearcherDto;
import com.narvee.dto.ListInterview;
import com.narvee.dto.ReqCommentDTO;
import com.narvee.dto.ReqCommentRequest;
import com.narvee.dto.RequirementDTO;
import com.narvee.dto.SubmissionDTO;
import com.narvee.dto.Tbl_rec_requirementDTO;
import com.narvee.repository.IReportRepository;
import com.narvee.service.IReportService;
import com.narvee.service.RequestDTO;
import com.narvee.util.JwtUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
implements IReportService {
    private static final Logger logger = LoggerFactory.getLogger(ReportServiceImpl.class);
    @Autowired
    private IReportRepository repository;

    public List<ConsultantReportDTO> consutantReport(DateSearcherDto dateSearcherDto, String companyid, String token) {
        logger.info("!!! inside class: ReportServiceImpl, method : consutantReport");
        List assignedCompanies = JwtUtil.getAssociatedCompanyIds((String)token);
        LocalDateTime startdateTime = this.startdateTime(dateSearcherDto.getStartDate());
        LocalDateTime enddateTime = this.enddateTime(dateSearcherDto.getEndDate());
        if (dateSearcherDto.getGroupby().equalsIgnoreCase("employee")) {
            return this.repository.consutantReportGroupbyEmployee(startdateTime, enddateTime, dateSearcherDto.getFlg(), assignedCompanies);
        }
        if (dateSearcherDto.getGroupby().equalsIgnoreCase("requirements")) {
            return this.repository.consutantReportGroupbyImplPartner(dateSearcherDto.getFlg(), startdateTime, enddateTime, assignedCompanies);
        }
        if (dateSearcherDto.getGroupby().equalsIgnoreCase("ImplPartner")) {
            return this.repository.consutantReportGroupbyImplPartner(dateSearcherDto.getFlg(), startdateTime, enddateTime, assignedCompanies);
        }
        return this.repository.consutantReportGroupbyConsultant(dateSearcherDto.getFlg(), startdateTime, enddateTime, assignedCompanies);
    }

    public List<ConsultantReportDTO> sourcingReport(DateSearcherDto dateSearcherDto, String companyid, String token) {
        logger.info("!!! inside class: ReportServiceImpl, method : sourcingReport");
        List assignedCompanies = JwtUtil.getAssociatedCompanyIds((String)token);
        LocalDateTime startdateTime = this.startdateTime(dateSearcherDto.getStartDate());
        LocalDateTime enddateTime = this.enddateTime(dateSearcherDto.getEndDate());
        List report = this.repository.presalesSourcingReport(startdateTime, enddateTime, assignedCompanies);
        return report;
    }

    public List<ListInterview> reportDrillDownsearch(DateSearcherDto dateSearcherDto, String companyid, String token) {
        logger.info("!!! inside class: ReportServiceImpl, method : reportDrillDownsearch");
        List assignedCompanies = JwtUtil.getAssociatedCompanyIds((String)token);
        String status = dateSearcherDto.getStatus();
        String groupby = dateSearcherDto.getGroupby();
        ArrayList<String> statusArg = new ArrayList<String>();
        LocalDateTime startdateTime = this.startdateTime(dateSearcherDto.getStartDate());
        LocalDateTime enddateTime = this.enddateTime(dateSearcherDto.getEndDate());
        if (groupby.equalsIgnoreCase("consultant")) {
            statusArg.add(status);
            return this.repository.reportDrillDown(statusArg, startdateTime, enddateTime, dateSearcherDto.getId(), assignedCompanies);
        }
        if (groupby.equalsIgnoreCase("requirements")) {
            return this.repository.vendorWisePopupsWithStatus(dateSearcherDto.getStatus(), startdateTime, enddateTime, dateSearcherDto.getId(), dateSearcherDto.getFlg(), assignedCompanies);
        }
        statusArg.add(status);
        return this.repository.reportDrillDownForEmployee(statusArg, startdateTime, enddateTime, dateSearcherDto.getId(), assignedCompanies);
    }

    public List<SubmissionDTO> getsalessubmission(DateSearcherDto dateSearcherDto, String companyid, String token) {
        logger.info("!!! inside class: ReportServiceImpl, method : getsalessubmission");
        List assignedCompanies = JwtUtil.getAssociatedCompanyIds((String)token);
        String groupby = dateSearcherDto.getGroupby();
        LocalDateTime startdateTime = this.startdateTime(dateSearcherDto.getStartDate());
        LocalDateTime enddateTime = this.enddateTime(dateSearcherDto.getEndDate());
        if (groupby.equalsIgnoreCase("consultant")) {
            return this.repository.getsalessubmissionreport(startdateTime, enddateTime, dateSearcherDto.getId(), assignedCompanies);
        }
        if (groupby.equalsIgnoreCase("requirements")) {
            return this.repository.getRequirementsReport(startdateTime, enddateTime, dateSearcherDto.getId(), dateSearcherDto.getFlg(), assignedCompanies);
        }
        return this.repository.getsalessubmissionreportForEmployee(startdateTime, enddateTime, dateSearcherDto.getId(), assignedCompanies);
    }

    public List<ListInterview> getInterviewDropdown(DateSearcherDto dateSearcherDto, String companyid, String token) {
        logger.info("!!! inside class: ReportServiceImpl, method : getInterviewDropdown");
        List assignedCompanies = JwtUtil.getAssociatedCompanyIds((String)token);
        String groupby = dateSearcherDto.getGroupby();
        LocalDateTime startdateTime = this.startdateTime(dateSearcherDto.getStartDate());
        LocalDateTime enddateTime = this.enddateTime(dateSearcherDto.getEndDate());
        if (groupby.equalsIgnoreCase("consultant")) {
            return this.repository.getInterviewDropdown(startdateTime, enddateTime, dateSearcherDto.getId(), assignedCompanies);
        }
        if (groupby.equalsIgnoreCase("requirements")) {
            return this.repository.getInterviewsPopupForVendor(startdateTime, enddateTime, dateSearcherDto.getId(), dateSearcherDto.getFlg());
        }
        return this.repository.getInterviewDropdownForEmployee(startdateTime, enddateTime, dateSearcherDto.getId(), assignedCompanies);
    }

    public List<ConsultantDTO> recruiterleads(DateSearcherDto dateSearcherDto, String companyId, String token) {
        logger.info("!!! inside class: ReportServiceImpl, method : recruiterleads");
        List assignedCompanies = JwtUtil.getAssociatedCompanyIds((String)token);
        logger.info("Decrypted company IDs from frontend: {}", (Object)assignedCompanies);
        LocalDateTime startdateTime = this.startdateTime(dateSearcherDto.getStartDate());
        LocalDateTime enddateTime = this.enddateTime(dateSearcherDto.getEndDate());
        return this.repository.recruiterLeads(dateSearcherDto.getFlg(), dateSearcherDto.getId().longValue(), startdateTime, enddateTime, assignedCompanies);
    }

    public List<ConsultantDTO> sourceLeads(DateSearcherDto dateSearcherDto, String companyid, String token) {
        logger.info("!!! inside class: ReportServiceImpl, method : sourceLeads");
        List assingendCompanies = JwtUtil.getAssociatedCompanyIds((String)token);
        LocalDateTime startdateTime = this.startdateTime(dateSearcherDto.getStartDate());
        LocalDateTime enddateTime = this.enddateTime(dateSearcherDto.getEndDate());
        if (dateSearcherDto.getStatus().equals("sales")) {
            return this.repository.sourcingLeadsWithFlag(dateSearcherDto.getId().longValue(), startdateTime, enddateTime, assingendCompanies);
        }
        return this.repository.sourcingLeads(dateSearcherDto.getStatus(), dateSearcherDto.getFlg(), dateSearcherDto.getId().longValue(), startdateTime, enddateTime, assingendCompanies);
    }

    public LocalDateTime startdateTime(LocalDate date) {
        logger.info("!!! inside class: ReportServiceImpl, method : startdateTime");
        LocalDate startDate = date;
        LocalTime startTime = LocalTime.of(0, 0, 0);
        LocalDateTime startdateTimeWithTime = startDate.atTime(startTime);
        return startdateTimeWithTime;
    }

    public LocalDateTime enddateTime(LocalDate date) {
        logger.info("!!! inside class: ReportServiceImpl, method : enddateTime");
        LocalDate endtDate = date;
        LocalTime endTime = LocalTime.of(23, 59, 0);
        LocalDateTime enddateTimeWithTime = endtDate.atTime(endTime);
        return enddateTimeWithTime;
    }

    public Page<Tbl_rec_requirementDTO> reqJobCategoryCount(RequestDTO request) {
        logger.info("!!! inside class: ReportServiceImpl, method : reqJobCategoryCount");
        int pageNo = request.getPageNumber();
        int pageSize = request.getPageSize();
        String sortField = request.getSortField();
        String sortOrder = request.getSortOrder();
        String keyword = request.getKeyword();
        String flag = request.getFlag();
        String startDate = request.getStartDate();
        String endDate = request.getEndDate();
        String[] category = request.getCategorys();
        System.err.println(category[0]);
        if (sortField.equalsIgnoreCase("Skillset")) {
            sortField = "category_skill";
        } else if (sortField.equalsIgnoreCase("Count")) {
            sortField = "vendorcount";
        } else if (sortField.equalsIgnoreCase("Vendor")) {
            sortField = "vendor";
        } else if (sortField.equalsIgnoreCase("Source")) {
            sortField = "source";
        } else if (sortField.equalsIgnoreCase("Title")) {
            sortField = "job_title";
        } else if (sortField.equalsIgnoreCase("Category")) {
            sortField = "category_skill";
        } else if (sortField.equalsIgnoreCase("Emptype")) {
            sortField = "Employment_type";
        } else if (sortField.equalsIgnoreCase("Location")) {
            sortField = "job_location";
        } else if (sortField.equalsIgnoreCase("PostedOn")) {
            sortField = "posted_on";
        }
        Sort.Direction sortDirection = Sort.Direction.ASC;
        if (sortOrder != null && sortOrder.equalsIgnoreCase("desc")) {
            sortDirection = Sort.Direction.DESC;
        }
        Sort sort = Sort.by((Sort.Direction)sortDirection, (String[])new String[]{sortField});
        PageRequest pageable = PageRequest.of((int)(pageNo - 1), (int)pageSize, (Sort)sort);
        if (flag.equalsIgnoreCase("count")) {
            logger.info("!!! inside class: ReportServiceImpl, method : reqJobCategoryCount , empty ,count");
            return this.repository.reqJobCategoryCount(startDate, endDate, category, (Pageable)pageable);
        }
        if (flag.equalsIgnoreCase("popup")) {
            logger.info("!!! inside class: ReportServiceImpl, method : reqJobCategoryCount , empty ,popup");
            return this.repository.reqJobCategoryCountPopup(startDate, endDate, keyword, (Pageable)pageable);
        }
        logger.info("!!! inside class: ReportServiceImpl, method : reqJobCategoryCount ,Search");
        List reqData = this.repository.reqJobCategoryCount(startDate, endDate, category);
        Pattern pattern = Pattern.compile("(?i).*" + keyword + ".*");
        List filteredContent = reqData.stream().filter(applicant -> {
            Matcher matcher = pattern.matcher(applicant.getCategory_skill());
            return matcher.find();
        }).collect(Collectors.toList());
        pageSize = pageable.getPageSize();
        pageNo = pageable.getPageNumber();
        int start = pageNo * pageSize;
        int end = Math.min(start + pageSize, filteredContent.size());
        return new PageImpl(filteredContent.subList(start, end), (Pageable)pageable, (long)filteredContent.size());
    }

    public List<String> getAllCategorys() {
        logger.info("!!! inside class: ReportServiceImpl, method : reqJobCategoryCount ,Search");
        return this.repository.getAllCategorys();
    }

    public List<ConsultantReportDTO> employeeIndividualReport(DateSearcherDto dateSearcherDto) {
        logger.info("!!! inside class: ReportServiceImpl, method : employeeIndividualReport");
        return this.repository.getRec_RecruiremntReport(dateSearcherDto.getStartDate(), dateSearcherDto.getEndDate(), dateSearcherDto.getId());
    }

    public List<ListInterview> employeeIntervStatusPopups(DateSearcherDto dateSearcherDto) {
        logger.info("!!! inside class: ReportServiceImpl, method : employeeIntervStatusPopups");
        ArrayList<String> status = new ArrayList<String>();
        status.add(dateSearcherDto.getStatus());
        return this.repository.reportDrillDownSearch(status, dateSearcherDto.getStartDate(), dateSearcherDto.getEndDate(), dateSearcherDto.getId());
    }

    public List<SubmissionDTO> employeeSubPopup(DateSearcherDto dateSearcherDto) {
        logger.info("!!! inside class: ReportServiceImpl, method : employeeSubPopup");
        return this.repository.employeeSubPopup(dateSearcherDto.getStartDate(), dateSearcherDto.getEndDate(), dateSearcherDto.getId());
    }

    public List<ConsultantReportDTO> allEmployeesReport(DateSearcherDto dateSearcherDto, String companyid, String token) {
        logger.info("!!! inside class: ReportServiceImpl, method : allEmployeesReport");
        List assignedCompanies = JwtUtil.getAssociatedCompanyIds((String)token);
        return this.repository.getAllEmployeeReport(dateSearcherDto.getStartDate(), dateSearcherDto.getEndDate(), assignedCompanies);
    }

    public List<SubmissionDTO> getEmployeeSubmissionPopup(DateSearcherDto dateSearcherDto, String companyid, String token) {
        logger.info("!!! inside class: ReportServiceImpl, method : getEmployeeSubmissionPopup");
        List assingedCompaies = JwtUtil.getAssociatedCompanyIds((String)token);
        return this.repository.getEmployeeSubmissionPopups(dateSearcherDto.getStartDate(), dateSearcherDto.getEndDate(), dateSearcherDto.getId(), assingedCompaies);
    }

    public List<AppliedListDTO> getemployeeJobApplyPopup(DateSearcherDto dateSearcherDto, String companyid, String token) {
        logger.info("!!! inside class: ReportServiceImpl, method : getemployeeJobApplyPopup");
        List assignedCompanies = JwtUtil.getAssociatedCompanyIds((String)token);
        return this.repository.getEmployeeJobApplyPopup(dateSearcherDto.getStartDate(), dateSearcherDto.getEndDate(), dateSearcherDto.getId(), assignedCompanies);
    }

    public List<ListInterview> getEmployeeInterviewStatPopups(DateSearcherDto dateSearcherDto, String companyid, String token) {
        logger.info("!!! inside class: ReportServiceImpl, method : getEmployeeInterviewStatPopups");
        List assignedCompanies = JwtUtil.getAssociatedCompanyIds((String)token);
        return this.repository.getEmployeeInterviewStatPopup(dateSearcherDto.getStartDate(), dateSearcherDto.getEndDate(), dateSearcherDto.getId(), dateSearcherDto.getStatus(), assignedCompanies);
    }

    public List<RequirementDTO> getrequirementPopUps(DateSearcherDto dateSearcherDto) {
        logger.info("!!! inside class: ReportServiceImpl, method : getEmployeeInterviewStatPopups");
        return this.repository.requirementPopUp(dateSearcherDto.getStartDate(), dateSearcherDto.getEndDate(), dateSearcherDto.getId(), dateSearcherDto.getFlg());
    }

    public Page<ReqCommentDTO> reqCommentReportWithPagination(ReqCommentRequest reqcommentResponse) {
        logger.info("!!! inside class: ReportServiceImpl, method : reqCommentReportWithPagination");
        int pageNo = reqcommentResponse.getPageNumber();
        int pageSize = reqcommentResponse.getPageSize();
        String sortField = reqcommentResponse.getSortField();
        String sortOrder = reqcommentResponse.getSortOrder();
        String keyword = reqcommentResponse.getKeyword();
        LocalDate startDate = reqcommentResponse.getStartDate();
        LocalDate endDate = reqcommentResponse.getEndDate();
        sortField = sortField.equalsIgnoreCase("consultantname") ? "consultantname" : (sortField.equalsIgnoreCase("jobtitle") ? "jobtitle" : (sortField.equalsIgnoreCase("comment") ? "comment" : (sortField.equalsIgnoreCase("fullname") ? "fullname" : (sortField.equalsIgnoreCase("issuetype") ? "issue_type" : (sortField.equalsIgnoreCase("createddate") ? "createddate" : "updateddate")))));
        Sort.Direction sortDirection = Sort.Direction.ASC;
        if (sortOrder != null && sortOrder.equalsIgnoreCase("desc")) {
            sortDirection = Sort.Direction.DESC;
        }
        Sort sort = Sort.by((Sort.Direction)sortDirection, (String[])new String[]{sortField});
        PageRequest pageable = PageRequest.of((int)(pageNo - 1), (int)pageSize, (Sort)sort);
        if (keyword.equalsIgnoreCase("empty")) {
            return this.repository.reqCommentReportWithPagination((Pageable)pageable, startDate, endDate);
        }
        return this.repository.reqCommentReportWithSearching((Pageable)pageable, startDate, endDate, keyword);
    }

    public List<ReqCommentDTO> reqCommentReport(ReqCommentRequest reqcommentResponse, String companyid, String token) {
        logger.info("!!! inside class: ReportServiceImpl, method : reqCommentReportWithPagination");
        List assignedCompanies = JwtUtil.getAssociatedCompanyIds((String)token);
        LocalDate startDate = reqcommentResponse.getStartDate();
        LocalDate endDate = reqcommentResponse.getEndDate();
        return this.repository.reqCommentReport(startDate, endDate, assignedCompanies);
    }
}

