/*
 * Decompiled with CFR 0.152.
 */
package com.narvee.serviceimpl;

import com.narvee.dto.BestPerformer;
import com.narvee.dto.EncryptionUtil;
import com.narvee.dto.Iratings;
import com.narvee.dto.RatingDropDown;
import com.narvee.dto.ReqCommentRequest;
import com.narvee.dto.ratingsDto;
import com.narvee.entity.Ratings;
import com.narvee.repository.ratingsRepo;
import com.narvee.service.IRatingsService;
import com.narvee.util.JwtUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class RatingsServiceImpl
implements IRatingsService {
    final Logger logger = LoggerFactory.getLogger(RatingsServiceImpl.class);
    @Autowired
    private ratingsRepo ratingsRepo;

    public List<RatingDropDown> getTlsByManagerId(Long ManagerId, String companyid) {
        this.logger.info("!!! inside class: RatingsServiceImpl, method : getTlsByManagerId");
        Long[] companyId = new Long[]{};
        try {
            if (companyid != null && !companyid.isBlank()) {
                String[] encryptedIds = companyid.split(",");
                ArrayList<Long> decryptedList = new ArrayList<Long>();
                for (String encrypted : encryptedIds) {
                    if (encrypted == null || encrypted.trim().isEmpty()) continue;
                    decryptedList.add(EncryptionUtil.decrypt((String)encrypted.trim()));
                }
                companyId = decryptedList.toArray(new Long[0]);
            }
        }
        catch (Exception e) {
            this.logger.error("Error decrypting company IDs", (Throwable)e);
        }
        Long roleId = this.ratingsRepo.findRoleidByUserId(ManagerId, companyId);
        List results = null;
        results = roleId == 1L ? this.ratingsRepo.findUsersBySuperAdminId(companyId) : this.ratingsRepo.findTlsBymanagerId(ManagerId, companyId);
        List<RatingDropDown> dtoList = results.stream().map(obj -> new RatingDropDown(Long.valueOf(((BigInteger)obj[0]).longValue()), (String)obj[1], (String)obj[2])).collect(Collectors.toList());
        return dtoList;
    }

    public List<RatingDropDown> getUsersByTLid(Long TL) {
        this.logger.info("!!! inside class: RatingsServiceImpl, method : getUsersByTLid");
        List results = this.ratingsRepo.findUsersByTlId(TL);
        List<RatingDropDown> dtoList = results.stream().map(obj -> new RatingDropDown(Long.valueOf(((BigInteger)obj[0]).longValue()), (String)obj[1], (String)obj[2])).collect(Collectors.toList());
        return dtoList;
    }

    public void saveRatings(ratingsDto ratingsDto2) {
        this.logger.info("!!! inside class: RatingsServiceImpl, method : saveRatings");
        Ratings ratings = new Ratings();
        ratings.setId(ratingsDto2.getId());
        ratings.setRatingType(ratingsDto2.getRatingType());
        ratings.setRatedTo(ratingsDto2.getRatedTo());
        ratings.setTeamLead(ratingsDto2.getTeamLead());
        ratings.setUpdatedBy(ratingsDto2.getUpdatedBy());
        ratings.setRatedBy(ratingsDto2.getRatedBy());
        ratings.setRating(ratingsDto2.getRating());
        ratings.setFeedBack(ratingsDto2.getFeedBack());
        ratings.setManager(ratingsDto2.getManager());
        if (ratings.getRatedTo() == null) {
            ratings.setRatedTo(ratingsDto2.getTeamLead());
        }
        this.ratingsRepo.save((Object)ratings);
    }

    public void deleteRatings(long Id2) {
        this.logger.info("!!! inside class: RatingsServiceImpl, method : deleteRatings");
        this.ratingsRepo.deleteById((Object)Id2);
    }

    public Page<Iratings> getRatings(ReqCommentRequest commenRequest, String companyid) {
        this.logger.info("!!! inside class: RatingsServiceImpl, method : getRatings");
        Long[] companyId = new Long[]{};
        try {
            if (companyid != null && !companyid.isBlank()) {
                String[] encryptedIds = companyid.split(",");
                ArrayList<Long> decryptedList = new ArrayList<Long>();
                for (String encrypted : encryptedIds) {
                    if (encrypted == null || encrypted.trim().isEmpty()) continue;
                    decryptedList.add(EncryptionUtil.decrypt((String)encrypted.trim()));
                }
                companyId = decryptedList.toArray(new Long[0]);
            }
        }
        catch (Exception e) {
            this.logger.error("Error decrypting company IDs", (Throwable)e);
        }
        int pageSize = commenRequest.getPageSize();
        int pageNumber = commenRequest.getPageNumber();
        String keyword = commenRequest.getKeyword();
        String sortOrder = commenRequest.getSortOrder();
        String sortField = commenRequest.getSortField();
        if (sortField.equalsIgnoreCase("RatedBy")) {
            sortField = "ratedby";
        } else if (sortField.equalsIgnoreCase("RatedTo")) {
            sortField = "ratedto";
        } else if (sortField.equalsIgnoreCase("FeedBack")) {
            sortField = "feedBack";
        } else if (sortField.equalsIgnoreCase("rating")) {
            sortField = "Rating";
        } else if (sortField.equalsIgnoreCase("TeamLead")) {
            sortField = "teamLead";
        }
        PageRequest pageable = PageRequest.of((int)(pageNumber - 1), (int)pageSize);
        if (keyword.equalsIgnoreCase("empty")) {
            Sort.Direction sortDirection = Sort.Direction.ASC;
            if (sortOrder != null && sortOrder.equalsIgnoreCase("desc")) {
                sortDirection = Sort.Direction.DESC;
            }
            Sort sort = Sort.by((Sort.Direction)sortDirection, (String[])new String[]{sortField});
            pageable = PageRequest.of((int)(pageNumber - 1), (int)pageSize, (Sort)sort);
            return this.ratingsRepo.findAllRatings((Pageable)pageable, companyId);
        }
        this.logger.info("!!! inside class : EmailExtractionImpl, !! method :getAll filter");
        return this.ratingsRepo.findAllRatingsWithSearching((Pageable)pageable, keyword, companyId);
    }

    public ratingsDto getRatingsById(Long Id2) {
        this.logger.info("!!! inside class: RatingsServiceImpl, method : getRatingsById");
        Optional dto = this.ratingsRepo.findById((Object)Id2);
        return dto.map(arg_0 -> this.convertToDto(arg_0)).orElseThrow(() -> new RuntimeException("Rating not found with ID: " + Id2));
    }

    public BestPerformer getBestPerformer(String ratingType, String companyid, String token) {
        List assignedComapny = JwtUtil.getAssociatedCompanyIds((String)token);
        BestPerformer performer = this.ratingsRepo.findBestPerformer(ratingType, assignedComapny);
        return performer;
    }

    private ratingsDto convertToDto(Ratings rating) {
        ratingsDto dto = new ratingsDto();
        dto.setId(rating.getId());
        dto.setRatingType(rating.getRatingType());
        dto.setUpdatedBy(rating.getUpdatedBy());
        dto.setRatedTo(rating.getRatedTo());
        dto.setTeamLead(rating.getTeamLead());
        dto.setRatedBy(rating.getRatedBy());
        dto.setRating(rating.getRating());
        dto.setFeedBack(rating.getFeedBack());
        dto.setManager(rating.getManager());
        return dto;
    }
}

