/*
 * Decompiled with CFR 0.152.
 */
package com.narvee.serviceimpl;

import com.narvee.dto.BanterReportDTO;
import com.narvee.dto.CallDataRequestDTO;
import com.narvee.dto.CallDataResponse;
import com.narvee.dto.CallRecordResponseDTO;
import com.narvee.dto.DateSearcherDto;
import com.narvee.entity.CallRecordReport;
import com.narvee.feignclient.BanterApiClient;
import com.narvee.repository.CallRecordRepository;
import com.narvee.service.ICallRecordService;
import com.narvee.util.JwtUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class CallRecordServiceImpl
implements ICallRecordService {
    final Logger logger = LoggerFactory.getLogger(CallRecordServiceImpl.class);
    @Autowired
    private CallRecordRepository callRecordRepository;
    @Autowired
    private BanterApiClient apiClient;

    public List<CallRecordReport> saverecordsscheduler() {
        List banternos = this.callRecordRepository.banternumber();
        LocalDateTime maxdate = this.callRecordRepository.maxdate();
        LinkedList<CallRecordReport> listCallreport = new LinkedList<CallRecordReport>();
        for (String number : banternos) {
            ZoneId chicagoZone = ZoneId.of("America/Chicago");
            LocalDateTime now = LocalDateTime.now(chicagoZone);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            this.logger.info("!!! inside class: CallRecordServiceImpl, method : saverecordsscheduler");
            String formattedmaxDateTime = maxdate.format(formatter);
            String formattedtodayDateTime = now.format(formatter);
            CallDataRequestDTO callDataRequestDTO = new CallDataRequestDTO();
            callDataRequestDTO.setNumber(number);
            callDataRequestDTO.setLimit(100000);
            callDataRequestDTO.setOffset(0);
            callDataRequestDTO.setFrom_date(formattedmaxDateTime);
            callDataRequestDTO.setTo_date(formattedtodayDateTime);
            CallRecordResponseDTO callrecreport = this.apiClient.fetchData(callDataRequestDTO, "91b9aabd35644151be906ffbd683d8e7");
            for (CallDataResponse callRecordResponseDTO : callrecreport.getData()) {
                CallRecordReport callrepo = new CallRecordReport();
                callrepo.setBillmin(callRecordResponseDTO.getBillmin());
                callrepo.setCallerId(callRecordResponseDTO.getCaller_id());
                callrepo.setCallFrom(callRecordResponseDTO.getCall_from());
                callrepo.setCallTo(callRecordResponseDTO.getCall_to());
                callrepo.setCallType(callRecordResponseDTO.getCall_type());
                callrepo.setCreatedDate(callRecordResponseDTO.getCreated_date());
                callrepo.setDirection(callRecordResponseDTO.getDirection());
                callrepo.setDuration(callRecordResponseDTO.getDuration());
                callrepo.setEndTime(callRecordResponseDTO.getEnd_time());
                callrepo.setStartTime(callRecordResponseDTO.getStart_time());
                listCallreport.add(callrepo);
            }
        }
        List data = this.callRecordRepository.saveAll(listCallreport);
        if (data != null) {
            return data;
        }
        return null;
    }

    public List<CallRecordReport> saverecordsschedulers(CallDataRequestDTO calldatadto) {
        List banternos = this.callRecordRepository.banternumber();
        LinkedList<CallRecordReport> listCallreport = new LinkedList<CallRecordReport>();
        for (String number : banternos) {
            ZoneId chicagoZone = ZoneId.of("America/Chicago");
            LocalDateTime now = LocalDateTime.now(chicagoZone);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            CallDataRequestDTO callDataRequestDTO = new CallDataRequestDTO();
            callDataRequestDTO.setNumber(number);
            callDataRequestDTO.setLimit(calldatadto.getLimit());
            callDataRequestDTO.setOffset(0);
            callDataRequestDTO.setFrom_date(calldatadto.getFrom_date());
            callDataRequestDTO.setTo_date(calldatadto.getTo_date());
            CallRecordResponseDTO callrecreport = this.apiClient.fetchData(callDataRequestDTO, "91b9aabd35644151be906ffbd683d8e7");
            List totaldbdata = this.callRecordRepository.findAll();
            for (CallDataResponse callRecordResponseDTO : callrecreport.getData()) {
                List dbdata = this.callRecordRepository.findduplicatedata(callRecordResponseDTO.getCreated_date(), callRecordResponseDTO.getStart_time(), callRecordResponseDTO.getEnd_time(), callRecordResponseDTO.getBillmin(), callRecordResponseDTO.getCall_from(), callRecordResponseDTO.getCall_to(), callRecordResponseDTO.getCall_type(), callRecordResponseDTO.getCaller_id(), callRecordResponseDTO.getDirection(), callRecordResponseDTO.getDuration());
                if (!dbdata.isEmpty()) continue;
                CallRecordReport callrepo = new CallRecordReport();
                callrepo.setBillmin(callRecordResponseDTO.getBillmin());
                callrepo.setCallerId(callRecordResponseDTO.getCaller_id());
                callrepo.setCallFrom(callRecordResponseDTO.getCall_from());
                callrepo.setCallTo(callRecordResponseDTO.getCall_to());
                callrepo.setCallType(callRecordResponseDTO.getCall_type());
                callrepo.setCreatedDate(callRecordResponseDTO.getCreated_date());
                callrepo.setDirection(callRecordResponseDTO.getDirection());
                callrepo.setDuration(callRecordResponseDTO.getDuration());
                callrepo.setEndTime(callRecordResponseDTO.getEnd_time());
                callrepo.setStartTime(callRecordResponseDTO.getStart_time());
                listCallreport.add(callrepo);
            }
        }
        List data = this.callRecordRepository.saveAll(listCallreport);
        if (data != null) {
            return data;
        }
        return null;
    }

    public List<BanterReportDTO> banterCallReport(DateSearcherDto calldto, String companyid, String token) {
        this.logger.info("!!! inside class: CallRecordServiceImpl, method : banterCallReport");
        List assignedCompaies = JwtUtil.getAssociatedCompanyIds((String)token);
        List banterreport = null;
        try {
            banterreport = calldto.getId() == null || calldto.getId() == 0L ? this.callRecordRepository.banterReport(calldto.getStartDate(), calldto.getEndDate(), calldto.getFlg(), assignedCompaies) : this.callRecordRepository.individualbanterReport(calldto.getStartDate(), calldto.getEndDate(), calldto.getFlg(), calldto.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return banterreport;
    }

    @Scheduled(cron="0 01 05 * * ?", zone="Asia/Kolkata")
    public List<CallRecordReport> saverecordsschedulers() {
        this.logger.info("!!! inside class: CallRecordServiceImpl, method : saverecordsschedulers");
        List banternos = this.callRecordRepository.banternumber();
        String maxdate = this.callRecordRepository.maxdates();
        LinkedList<CallRecordReport> listCallreport = new LinkedList<CallRecordReport>();
        for (String number : banternos) {
            ZoneId indiaZone = ZoneId.of("Asia/Kolkata");
            LocalDate now = LocalDate.now(indiaZone);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate fromTime = LocalDate.parse(maxdate, formatter);
            String toTime = now.format(formatter);
            CallDataRequestDTO callDataRequestDTO = new CallDataRequestDTO();
            callDataRequestDTO.setNumber(number);
            callDataRequestDTO.setLimit(100000000);
            callDataRequestDTO.setOffset(0);
            callDataRequestDTO.setFrom_date(fromTime.toString());
            callDataRequestDTO.setTo_date(toTime);
            this.logger.info("!!! inside class: CallRecordServiceImpl, method : saverecordsscheduler");
            CallRecordResponseDTO callrecreport = this.apiClient.fetchData(callDataRequestDTO, "91b9aabd35644151be906ffbd683d8e7");
            for (CallDataResponse callRecordResponseDTO : callrecreport.getData()) {
                this.logger.info("!!! inside class: CallRecordServiceImpl, method : saverecordsscheduler , forloop");
                CallRecordReport callrepo = new CallRecordReport();
                callrepo.setBillmin(callRecordResponseDTO.getBillmin());
                callrepo.setCallerId(callRecordResponseDTO.getCaller_id());
                callrepo.setCallFrom(callRecordResponseDTO.getCall_from());
                callrepo.setCallTo(callRecordResponseDTO.getCall_to());
                callrepo.setCallType(callRecordResponseDTO.getCall_type());
                callrepo.setCreatedDate(callRecordResponseDTO.getCreated_date());
                callrepo.setDirection(callRecordResponseDTO.getDirection());
                callrepo.setDuration(callRecordResponseDTO.getDuration());
                callrepo.setEndTime(callRecordResponseDTO.getEnd_time());
                callrepo.setStartTime(callRecordResponseDTO.getStart_time());
                listCallreport.add(callrepo);
            }
        }
        this.logger.info("!!! inside class: CallRecordServiceImpl, method : saverecordsscheduler , end");
        List data = this.callRecordRepository.saveAll(listCallreport);
        if (data != null) {
            return data;
        }
        return null;
    }

    public List<CallRecordReport> saverecordsschedulerss() {
        System.err.println("insie first of =======================");
        List banternos = this.callRecordRepository.banternumber();
        LinkedList<CallRecordReport> listCallreport = new LinkedList<CallRecordReport>();
        for (String number : banternos) {
            this.logger.info("!!! inside class: CallRecordServiceImpl, method : saverecordsscheduler");
            CallDataRequestDTO callDataRequestDTO = new CallDataRequestDTO();
            callDataRequestDTO.setNumber(number);
            callDataRequestDTO.setLimit(100000000);
            callDataRequestDTO.setOffset(0);
            callDataRequestDTO.setFrom_date("2023-11-18");
            callDataRequestDTO.setTo_date("2024-07-14");
            CallRecordResponseDTO callrecreport = this.apiClient.fetchData(callDataRequestDTO, "91b9aabd35644151be906ffbd683d8e7");
            for (CallDataResponse callRecordResponseDTO : callrecreport.getData()) {
                CallRecordReport callrepo = new CallRecordReport();
                callrepo.setBillmin(callRecordResponseDTO.getBillmin());
                callrepo.setCallerId(callRecordResponseDTO.getCaller_id());
                callrepo.setCallFrom(callRecordResponseDTO.getCall_from());
                callrepo.setCallTo(callRecordResponseDTO.getCall_to());
                callrepo.setCallType(callRecordResponseDTO.getCall_type());
                callrepo.setCreatedDate(callRecordResponseDTO.getCreated_date());
                callrepo.setDirection(callRecordResponseDTO.getDirection());
                callrepo.setDuration(callRecordResponseDTO.getDuration());
                callrepo.setEndTime(callRecordResponseDTO.getEnd_time());
                callrepo.setStartTime(callRecordResponseDTO.getStart_time());
                listCallreport.add(callrepo);
            }
        }
        List data = this.callRecordRepository.saveAll(listCallreport);
        if (data != null) {
            return data;
        }
        return null;
    }
}

