/*
 * Decompiled with CFR 0.152.
 */
package com.narvee.repository;

import com.narvee.dto.BestPerformer;
import com.narvee.dto.Iratings;
import com.narvee.entity.Ratings;
import feign.Param;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface ratingsRepo
extends JpaRepository<Ratings, Long> {
    @Query(nativeQuery=true, value="select role_roleid from users where userid=:userid and userid in (select uc.userid from user_companies uc where uc.companyids in (:id))")
    public Long findRoleidByUserId(Long var1, Long[] var2);

    @Query(value=" select u.userid,u.pseudoname,u.fullname from users u where u.manager  = :manager and u.isteamlead = 1 and u.status = 'Active' and u.userid in (select uc.userid from user_companies uc where uc.companyids in (:id))", nativeQuery=true)
    public List<Object[]> findTlsBymanagerId(Long var1, Long[] var2);

    @Query(value=" select u.userid,u.pseudoname,u.fullname from users u where u.teamlead  = :TL and u.status = 'Active'  ", nativeQuery=true)
    public List<Object[]> findUsersByTlId(Long var1);

    @Query(value="select u.userid,u.pseudoname,u.fullname from users u where u.ismanager  =1 and u.status = 'Active' and u.userid in (select uc.userid from user_companies uc where uc.companyids in (:id))", nativeQuery=true)
    public List<Object[]> findUsersBySuperAdminId(Long[] var1);

    @Query(value="SELECT  r.rating, u1.pseudoname AS rated_by,  u2.pseudoname AS rated_to, r.remarks FROM ratings r JOIN users u1 ON u1.userid = r.rated_by JOIN users u2 ON u2.userid = r.rated_to WHERE u1.userid = :userid", nativeQuery=true)
    public List<Iratings> findRatings(Long var1);

    @Query(value="SELECT r.id, r.rating, u1.pseudoname AS ratedby,  u2.pseudoname AS ratedto, r.feed_back AS feedBack ,   u3.pseudoname AS teamLead ,r.rating_Type As ratingType, u4.pseudoname AS manager   FROM ratings r \t\tLEFT JOIN users u1 ON u1.userid = r.rated_by \t\tLEFT JOIN users u2 ON u2.userid = r.rated_to \t\tLEFT JOIN users u3 ON u3.userid = r.team_lead      LEFT JOIN users u4 ON u4.userid = r.manager     where u1.userid in (select uc.userid from user_companies uc where uc.companyids in (:id)) and r.rating LIKE CONCAT('%',:keyword,'%') OR u1.pseudoname LIKE CONCAT('%',:keyword,'%')   OR   u2.pseudoname LIKE CONCAT('%',:keyword,'%') OR  r.feed_back LIKE CONCAT('%',:keyword,'%')   OR  u3.pseudoname LIKE CONCAT('%',:keyword,'%') OR r.rating_Type LIKE CONCAT('%',:keyword,'%') OR u4.pseudoname LIKE CONCAT('%',:keyword,'%') ", nativeQuery=true)
    public Page<Iratings> findAllRatingsWithSearching(Pageable var1, String var2, Long[] var3);

    @Query(value="SELECT r.id, r.rating, u1.pseudoname AS ratedBy,  u2.pseudoname AS ratedTo, r.feed_back AS feedBack ,   u3.pseudoname AS teamLead ,r.rating_Type As ratingType , u4.pseudoname AS manager    FROM ratings r \t  LEFT\tJOIN users u1 ON u1.userid = r.rated_by \t  LEFT\tJOIN users u2 ON u2.userid = r.rated_to \t  LEFT\tJOIN users u3 ON u3.userid = r.team_lead    LEFT\tJOIN users u4 ON u4.userid = r.manager  where u1.userid in (select uc.userid from user_companies uc where uc.companyids in (:id)) ", nativeQuery=true)
    public Page<Iratings> findAllRatings(Pageable var1, Long[] var2);

    @Query(value=" SELECT u.pseudoname AS rated_to, AVG(r.rating) AS avg_rating, r.rating_type AS ratingType  FROM ratings r  JOIN users u ON u.userid = r.rated_to  WHERE r.rating_type = :ratingType AND u.userid in (select uc.userid from user_companies uc where uc.companyids in (:companyId)) AND (    (:ratingType = 'DAILY' AND DATE(r.createddate) = DATE_SUB(CURRENT_DATE, INTERVAL 1 DAY))    OR (:ratingType = 'WEEKLY' AND YEAR(r.createddate) = YEAR(CURRENT_DATE) AND WEEK(r.createddate, 1) = WEEK(CURRENT_DATE, 1) - 1)    OR (:ratingType = 'MONTHLY' AND YEAR(r.createddate) = YEAR(CURRENT_DATE) AND MONTH(r.createddate) = MONTH(CURRENT_DATE) - 1)  )  GROUP BY r.rated_to, u.pseudoname, r.rating_type  ORDER BY avg_rating DESC  LIMIT 1", nativeQuery=true)
    public BestPerformer findBestPerformer(@Param(value="ratingType") String var1, List<Long> var2);
}

