/*
 * Decompiled with CFR 0.152.
 */
package com.narvee.repository;

import com.narvee.dto.AppliedListDTO;
import com.narvee.dto.ConsultantDTO;
import com.narvee.dto.ConsultantReportDTO;
import com.narvee.dto.ListInterview;
import com.narvee.dto.ReqCommentDTO;
import com.narvee.dto.RequirementDTO;
import com.narvee.dto.SubmissionDTO;
import com.narvee.dto.Tbl_rec_requirementDTO;
import com.narvee.entity.Report;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface IReportRepository
extends JpaRepository<Report, Long> {
    @Query(value="WITH latest_per_interview AS (   SELECT interviewno, addedby, interview_status   FROM (     SELECT ci.interviewno, ci.addedby, ci.interview_status,            ROW_NUMBER() OVER (PARTITION BY ci.interviewno ORDER BY ci.updateddate DESC, ci.id DESC) AS rn     FROM interview ci     JOIN submission s ON ci.submissionid = s.subid     JOIN consultant_info c ON s.consultantid = c.consultantid     WHERE ci.flg = :flg       AND ci.createddate BETWEEN :startDate AND :endDate   ) x   WHERE rn = 1 ), agg AS (   SELECT addedby,          SUM(CASE WHEN interview_status = 'BackOut' THEN 1 ELSE 0 END) AS backout,          SUM(CASE WHEN interview_status = 'OnBoarded' THEN 1 ELSE 0 END) AS onboarded,          SUM(CASE WHEN interview_status = 'schedule' THEN 1 ELSE 0 END) AS schedule,          SUM(CASE WHEN interview_status = 'rejected' THEN 1 ELSE 0 END) AS rejected,          SUM(CASE WHEN interview_status = 'closed' THEN 1 ELSE 0 END) AS closed,          SUM(CASE WHEN interview_status = 'selected' THEN 1 ELSE 0 END) AS selected,          SUM(CASE WHEN interview_status = 'Hold' THEN 1 ELSE 0 END) AS onhold,          COUNT(*) AS interview_total   FROM latest_per_interview   GROUP BY addedby ), submission_cnt AS (   SELECT userid, COUNT(*) AS submission   FROM submission s   JOIN consultant_info c ON s.consultantid = c.consultantid   WHERE s.flg = :flg     AND s.createddate BETWEEN :startDate AND :endDate   GROUP BY userid ), consultant_cnt AS (   SELECT addedby, COUNT(*) AS consultant   FROM consultant_info con   WHERE con.consultantflg = :flg     AND con.createddate BETWEEN :startDate AND :endDate     AND con.company_id IN (:companyId)   GROUP BY addedby ) SELECT u.userid AS id, u.pseudoname,        COALESCE(a.backout, 0) AS backout,        COALESCE(a.onboarded, 0) AS onboarded,        COALESCE(a.schedule, 0) AS schedule,        COALESCE(a.rejected, 0) AS rejected,        COALESCE(a.closed, 0) AS closed,        COALESCE(a.selected, 0) AS selected,        COALESCE(a.onhold, 0) AS onhold,        COALESCE(a.interview_total, 0) AS interview,        COALESCE(s.submission, 0) AS submission,        COALESCE(c.consultant, 0) AS consultant FROM users u LEFT JOIN agg a ON u.userid = a.addedby LEFT JOIN submission_cnt s ON u.userid = s.userid LEFT JOIN consultant_cnt c ON u.userid = c.addedby WHERE u.companyid IN (:companyId)   AND u.department LIKE CONCAT('%', :flg, '%')   AND u.department != 'Dom Recruiting'   AND u.userid NOT IN (16, 29, 23)   AND u.status = 'Active'   AND (COALESCE(a.interview_total, 0) > 0 OR COALESCE(s.submission, 0) > 0 OR COALESCE(c.consultant, 0) > 0) ORDER BY u.pseudoname", nativeQuery=true)
    public List<ConsultantReportDTO> consutantReportGroupbyEmployee(@Param(value="startDate") LocalDateTime var1, @Param(value="endDate") LocalDateTime var2, @Param(value="flg") String var3, @Param(value="companyId") List<Long> var4);

    @Query(value="SELECT distinct v.company, v.id ,\r\n                 (SELECT COUNT(*) FROM rec_requirements r where v.id = r.vendorid and r.createddate between :startDate and :endDate and r.flg=:flg) AS req_count ,\r\n\t\t\t\t (SELECT COUNT(*) FROM submission s WHERE    v.id = s.vendorid and s.createddate between :startDate and :endDate and s.flg=:flg) AS submission,\r\n\t\t\t\t(SELECT COUNT(*) FROM interview i, submission s WHERE i.interview_status = 'schedule' AND   v.id = s.vendorid and i.submissionid = s.subid \r\n\t\t\t and i.createddate between :startDate and :endDate  and i.flg=:flg) AS schedule,\r\n\t\t\t (SELECT COUNT(*) FROM interview i, submission s  WHERE  v.id = s.vendorid and i.submissionid = s.subid and i.createddate between :startDate and :endDate and i.flg=:flg) AS interview,\r\n\t\t\t  (SELECT COUNT(*) FROM interview i, submission s  WHERE i.interview_status = 'BackOut' AND   v.id = s.vendorid and i.submissionid = s.subid and i.createddate between :startDate and :endDate  and i.flg=:flg) AS BackOut,\r\n\t\t\t(SELECT COUNT(*) FROM interview i, submission s  WHERE i.interview_status = 'OnBoarded' AND   v.id = s.vendorid and i.submissionid = s.subid and i.createddate between :startDate and :endDate   and i.flg=:flg) AS onboarded,\r\n\t\t\t (SELECT COUNT(*) FROM interview i, submission s  WHERE i.interview_status = 'rejected' AND   v.id = s.vendorid and i.submissionid = s.subid and i.createddate between :startDate and :endDate  and i.flg= :flg) AS rejected,\r\n\t\t\t\t\t (SELECT COUNT(*) FROM interview i, submission s  WHERE  i.interview_status = 'closed' AND   v.id = s.vendorid and i.submissionid = s.subid and i.createddate between :startDate and :endDate  and i.flg=:flg) AS closed,\r\n\t\t  (SELECT COUNT(*) FROM interview i, submission s  WHERE i.interview_status = 'selected' AND   v.id = s.vendorid and i.submissionid = s.subid and i.createddate between :startDate and :endDate  and i.flg=:flg ) AS selected,\r\n\t\t\t\t  (SELECT COUNT(*) FROM interview i, submission s  WHERE i.interview_status = 'Hold' AND   v.id = s.vendorid and i.submissionid = s.subid and i.createddate between :startDate and :endDate  and i.flg=:flg) AS onhold\r\n\t\t\t    FROM   vendor v , rec_requirements r join users u on r.addedby=u.userid where u.companyid in (:companyId) and v.id= r.vendorid and r.createddate between :startDate and :endDate  and r.flg=:flg and u.status='Active' order by   v.company asc", nativeQuery=true)
    public List<ConsultantReportDTO> requirementReport(@Param(value="startDate") LocalDateTime var1, @Param(value="endDate") LocalDateTime var2, @Param(value="flg") String var3, List<Long> var4);

    @Query(value="SELECT     c.consultantid AS id,     c.consultantname,     SUM(CASE WHEN i.interview_status = 'BackOut'   AND i.flg = :flg THEN 1 ELSE 0 END) AS backout,     SUM(CASE WHEN i.interview_status = 'OnBoarded' AND i.flg = :flg THEN 1 ELSE 0 END) AS onboarded,     SUM(CASE WHEN i.interview_status = 'schedule'  AND i.flg = :flg THEN 1 ELSE 0 END) AS schedule,     SUM(CASE WHEN i.interview_status = 'rejected'  AND i.flg = :flg THEN 1 ELSE 0 END) AS rejected,     SUM(CASE WHEN i.interview_status = 'Hold'      AND i.flg = :flg THEN 1 ELSE 0 END) AS onhold,     SUM(CASE WHEN i.interview_status = 'selected'  AND i.flg = :flg THEN 1 ELSE 0 END) AS selected,     SUM(CASE WHEN i.interview_status = 'closed'    AND i.flg = :flg THEN 1 ELSE 0 END) AS closed,     COUNT(DISTINCT i.id) AS interview,     COUNT(DISTINCT CASE WHEN sub.flg = :flg THEN sub.subid END) AS submission FROM consultant_info c JOIN technologies t ON t.id = c.techid JOIN visa v ON v.id = c.visa_status LEFT JOIN assign_consultant ac ON ac.consultantid = c.consultantid LEFT JOIN users u ON u.userid = ac.userid LEFT JOIN submission sub ON sub.consultantid = c.consultantid     AND sub.flg = :flg     AND sub.createddate BETWEEN :startDate AND :endDate LEFT JOIN interview i ON i.submissionid = sub.subid     AND i.flg = :flg     AND i.createddate BETWEEN :startDate AND :endDate WHERE c.company_id IN (:companyId)   AND c.consultantflg = :flg   AND c.status = 'Active' GROUP BY c.consultantid, c.consultantname HAVING COUNT(DISTINCT sub.subid) > 0 OR COUNT(DISTINCT i.id) > 0 ORDER BY c.consultantname ASC", nativeQuery=true)
    public List<ConsultantReportDTO> consutantReportGroupbyConsultant(@Param(value="flg") String var1, @Param(value="startDate") LocalDateTime var2, @Param(value="endDate") LocalDateTime var3, @Param(value="companyId") List<Long> var4);

    @Query(value="SELECT \r\n\t\t    v.company,\r\n\t\t    v.id,\r\n\t\t    \r\n\t\t    -- Requirements for Recruiting\r\n\t\t    CASE WHEN :flg = 'Recruiting' THEN COALESCE(r.req_count, 0) ELSE 0 END AS req_count,\r\n\t\t    \r\n\t\t    -- Submissions\r\n\t\t    CASE WHEN :flg = 'Recruiting' THEN COALESCE(s.sub_count, 0)\r\n\t\t         ELSE COALESCE(sales_sub.sub_count, 0) END AS submission,\r\n\t\t    \r\n\t\t    -- Schedule\r\n\t\t    CASE WHEN :flg = 'Recruiting' THEN COALESCE(i.schedule_count, 0)\r\n\t\t         ELSE COALESCE(sales_i.schedule_count, 0) END AS schedule,\r\n\t\t    \r\n\t\t    -- All interviews\r\n\t\t    CASE WHEN :flg = 'Recruiting' THEN COALESCE(i.total_count, 0)\r\n\t\t         ELSE COALESCE(sales_i.total_count, 0) END AS interview,\r\n\t\t    \r\n\t\t    -- BackOut\r\n\t\t    CASE WHEN :flg = 'Recruiting' THEN COALESCE(i.backout_count, 0)\r\n\t\t         ELSE COALESCE(sales_i.backout_count, 0) END AS backout,\r\n\t\t    \r\n\t\t    -- OnBoarded\r\n\t\t    CASE WHEN :flg = 'Recruiting' THEN COALESCE(i.onboarded_count, 0)\r\n\t\t         ELSE COALESCE(sales_i.onboarded_count, 0) END AS onboarded,\r\n\t\t    \r\n\t\t    -- Rejected\r\n\t\t    CASE WHEN :flg = 'Recruiting' THEN COALESCE(i.rejected_count, 0)\r\n\t\t         ELSE COALESCE(sales_i.rejected_count, 0) END AS rejected,\r\n\t\t    \r\n\t\t    -- Closed\r\n\t\t    CASE WHEN :flg = 'Recruiting' THEN COALESCE(i.closed_count, 0)\r\n\t\t         ELSE COALESCE(sales_i.closed_count, 0) END AS closed,\r\n\t\t    \r\n\t\t    -- Selected\r\n\t\t    CASE WHEN :flg = 'Recruiting' THEN COALESCE(i.selected_count, 0)\r\n\t\t         ELSE COALESCE(sales_i.selected_count, 0) END AS selected,\r\n\t\t    \r\n\t\t    -- OnHold\r\n\t\t    CASE WHEN :flg = 'Recruiting' THEN COALESCE(i.onhold_count, 0)\r\n\t\t         ELSE COALESCE(sales_i.onhold_count, 0) END AS onhold\r\n\r\n\t\tFROM vendor v\r\n\r\n\t\t-- Recruiting counts\r\n\t\tLEFT JOIN (\r\n\t\t    SELECT r.vendorid, COUNT(*) AS req_count\r\n\t\t    FROM rec_requirements r\r\n\t\t    WHERE r.flg='Recruiting' AND r.createddate BETWEEN :startDate AND :endDate\r\n\t\t    GROUP BY r.vendorid\r\n\t\t) r ON r.vendorid = v.id\r\n\r\n\t\tLEFT JOIN (\r\n\t\t    SELECT s.implpartner AS company, COUNT(*) AS sub_count\r\n\t\t    FROM submission s\r\n\t\t    WHERE s.flg='Recruiting' AND s.createddate BETWEEN :startDate AND :endDate\r\n\t\t    GROUP BY s.implpartner\r\n\t\t) s ON s.company = v.company\r\n\r\n\t\tLEFT JOIN (\r\n\t\t    SELECT s.vendorid,\r\n\t\t           COUNT(*) AS total_count,\r\n\t\t           SUM(CASE WHEN i.interview_status='schedule' THEN 1 ELSE 0 END) AS schedule_count,\r\n\t\t           SUM(CASE WHEN i.interview_status='BackOut' THEN 1 ELSE 0 END) AS backout_count,\r\n\t\t           SUM(CASE WHEN i.interview_status='OnBoarded' THEN 1 ELSE 0 END) AS onboarded_count,\r\n\t\t           SUM(CASE WHEN i.interview_status='rejected' THEN 1 ELSE 0 END) AS rejected_count,\r\n\t\t           SUM(CASE WHEN i.interview_status='closed' THEN 1 ELSE 0 END) AS closed_count,\r\n\t\t           SUM(CASE WHEN i.interview_status='selected' THEN 1 ELSE 0 END) AS selected_count,\r\n\t\t           SUM(CASE WHEN i.interview_status='Hold' THEN 1 ELSE 0 END) AS onhold_count\r\n\t\t    FROM interview i\r\n\t\t    JOIN submission s ON i.submissionid = s.subid\r\n\t\t    WHERE i.flg='Recruiting' AND i.createddate BETWEEN :startDate AND :endDate\r\n\t\t    GROUP BY s.vendorid\r\n\t\t) i ON i.vendorid = v.id\r\n\r\n\t\t-- Sales counts\r\n\t\tLEFT JOIN (\r\n\t\t    SELECT s.vendorid,\r\n\t\t           COUNT(*) AS sub_count\r\n\t\t    FROM submission s\r\n\t\t    JOIN users u ON s.userid = u.userid\r\n\t\t    WHERE s.flg='sales' \r\n\t\t      AND s.createddate BETWEEN :startDate AND :endDate\r\n\t\t      AND u.status='Active'\r\n\t\t      AND u.companyid IN :companyId\r\n\t\t    GROUP BY s.vendorid\r\n\t\t) sales_sub ON sales_sub.vendorid = v.id\r\n\r\n\t\tLEFT JOIN (\r\n\t\t    SELECT s.vendorid,\r\n\t\t           COUNT(*) AS total_count,\r\n\t\t           SUM(CASE WHEN i.interview_status='schedule' THEN 1 ELSE 0 END) AS schedule_count,\r\n\t\t           SUM(CASE WHEN i.interview_status='BackOut' THEN 1 ELSE 0 END) AS backout_count,\r\n\t\t           SUM(CASE WHEN i.interview_status='OnBoarded' THEN 1 ELSE 0 END) AS onboarded_count,\r\n\t\t           SUM(CASE WHEN i.interview_status='rejected' THEN 1 ELSE 0 END) AS rejected_count,\r\n\t\t           SUM(CASE WHEN i.interview_status='closed' THEN 1 ELSE 0 END) AS closed_count,\r\n\t\t           SUM(CASE WHEN i.interview_status='selected' THEN 1 ELSE 0 END) AS selected_count,\r\n\t\t           SUM(CASE WHEN i.interview_status='Hold' THEN 1 ELSE 0 END) AS onhold_count\r\n\t\t    FROM interview i\r\n\t\t    JOIN submission s ON i.submissionid = s.subid\r\n\t\t    JOIN users u ON s.userid = u.userid\r\n\t\t    WHERE i.flg='sales' \r\n\t\t      AND i.createddate BETWEEN :startDate AND :endDate\r\n\t\t      AND u.status='Active'\r\n\t\t      AND u.companyid IN :companyId\r\n\t\t    GROUP BY s.vendorid\r\n\t\t) sales_i ON sales_i.vendorid = v.id\r\n\r\n\t\tWHERE (:flg = 'Recruiting' AND r.req_count IS NOT NULL)\r\n\t\t   OR (:flg = 'sales' AND sales_sub.sub_count IS NOT NULL)\r\n\r\n\t\tORDER BY v.company ASC", nativeQuery=true)
    public List<ConsultantReportDTO> consutantReportGroupbyImplPartner(@Param(value="flg") String var1, @Param(value="startDate") LocalDateTime var2, @Param(value="endDate") LocalDateTime var3, @Param(value="companyId") List<Long> var4);

    @Query(value="SELECT u.userid, u.pseudoname,\r\n(SELECT COUNT(*) FROM consultant_info ci WHERE  ci.status = 'Initiated' AND ci.addedby = u.userid and (ci.createddate BETWEEN :startDate and :endDate or ci.updateddate BETWEEN :startDate and :endDate)) AS Initiated,\r\n(SELECT COUNT(*) FROM consultant_info ci WHERE  ci.status = 'Completed' AND ci.addedby = u.userid and (ci.createddate BETWEEN :startDate and :endDate or ci.updateddate BETWEEN :startDate and :endDate)) AS Completed,\r\n(SELECT COUNT(*) FROM consultant_info ci WHERE   ci.status = 'Rejected' AND ci.addedby = u.userid and (ci.createddate BETWEEN :startDate and :endDate or ci.updateddate BETWEEN :startDate and :endDate)) AS Rejected,\r\n(SELECT COUNT(*) FROM consultant_info ci WHERE ci.isfrompre_sales = 1 AND ci.addedby = u.userid and (ci.createddate BETWEEN :startDate and :endDate or ci.updateddate BETWEEN :startDate and :endDate) ) AS sales,\r\n(SELECT COUNT(*) FROM consultant_info ci WHERE   ci.status = 'Verified' AND ci.addedby = u.userid and ci.createddate BETWEEN :startDate and :endDate) AS Verified\r\nfrom consultant_info ci, users u where ci.addedby=u.userid and ci.company_id in (:companyId) and u.companyid in (:companyId) and u.department in('Sourcing') and (ci.createddate BETWEEN :startDate and :endDate or ci.updateddate BETWEEN :startDate and :endDate) group by u.userid, u.pseudoname order by userid asc", nativeQuery=true)
    public List<ConsultantReportDTO> presalesSourcingReport(@Param(value="startDate") LocalDateTime var1, @Param(value="endDate") LocalDateTime var2, List<Long> var3);

    @Query(value=" select i.interviewno, (select  v.company from vendor v where s.vendorid=v.id) as vendor,i.flg, s.endclient,c.consultantid as consid, c.consultantname as name, i.interview_date, i.round, i.mode,  s.createddate,\r\n u.userid, u.fullname,u.pseudoname, i.interview_status, i.time_zone, i.id as intrid, s.subid\r\n from interview i, consultant_info c, submission s , users u where c.company_id in (:companyId) and i.submissionid = s.subid and\r\n  s.consultantid = c.consultantid and  i.addedby = u.userid and i.createddate between :startDate and :endDate and c.consultantid=:id and i.interview_status in (:status) order by i.updateddate desc", nativeQuery=true)
    public List<ListInterview> reportDrillDown(@Param(value="status") List<String> var1, @Param(value="startDate") LocalDateTime var2, @Param(value="endDate") LocalDateTime var3, @Param(value="id") Long var4, List<Long> var5);

    @Query(value="select i.interviewno,v.company as vendor,i.flg, s.endclient,c.consultantid as consid, c.consultantname as name, i.interview_date, i.round, i.mode,  s.createddate,\r\n                 u.userid, u.fullname,u.pseudoname, i.interview_status, i.time_zone, i.id as intrid, s.subid\r\n                        from interview i, consultant_info c, submission s , users u , vendor v  where c.company_id in (:companyId) and i.submissionid = s.subid and\r\n                   s.consultantid = c.consultantid and  i.addedby = u.userid and i.createddate between :startDate and :endDate\r\n              and v.id=s.vendorid and i.interview_status in (:status) and s.flg=:flg and s.vendorid =:id order by i.updateddate desc", nativeQuery=true)
    public List<ListInterview> vendorWisePopupsWithStatus(@Param(value="status") String var1, @Param(value="startDate") LocalDateTime var2, @Param(value="endDate") LocalDateTime var3, @Param(value="id") Long var4, @Param(value="flg") String var5, List<Long> var6);

    @Query(value=" select i.interviewno,(select  v.company from vendor v where s.vendorid=v.id) as vendor,i.flg, s.endclient,c.consultantid as consid, c.consultantname as name, i.interview_date, i.round, i.mode,  s.createddate,\r\n u.userid, u.fullname,u.pseudoname, i.interview_status, i.time_zone, i.id as intrid, s.subid\r\n from interview i, consultant_info c, submission s , users u  where c.company_id in (:companyId) and i.submissionid = s.subid and\r\n  s.consultantid = c.consultantid and  i.addedby = u.userid and i.createddate between :startDate and :endDate and i.addedby =:id and i.interview_status in (:status) order by i.updateddate desc", nativeQuery=true)
    public List<ListInterview> reportDrillDownForEmployee(@Param(value="status") List<String> var1, @Param(value="startDate") LocalDateTime var2, @Param(value="endDate") LocalDateTime var3, @Param(value="id") Long var4, List<Long> var5);

    @Query(value="SELECT \r\n    v.company AS vendor,\r\n    u.userid,\r\n    u.fullname,\r\n    u.pseudoname,\r\n    c.consultantname,\r\n    c.consultantid,\r\n    COALESCE(t.createddate, s.createddate) AS createddate,\r\n    COALESCE(t.endclient, s.endclient) AS endclient,\r\n    COALESCE(t.implpartner, s.implpartner) AS implpartner,\r\n    COALESCE(t.position, s.position) AS position,\r\n    COALESCE(t.projectlocation, s.projectlocation) AS projectlocation,\r\n    s.status,\r\n    COALESCE(t.submissionrate, s.submissionrate) AS submissionrate,\r\n    s.substatus\r\nFROM submission s\r\nJOIN consultant_info c ON s.consultantid = c.consultantid\r\nJOIN users u ON u.userid = s.userid\r\nLEFT JOIN vendor v ON s.vendorid = v.id\r\nLEFT JOIN (\r\n    SELECT t1.*\r\n    FROM submission_track t1\r\n    JOIN (\r\n        SELECT subid, MAX(createddate) AS maxdate\r\n        FROM submission_track\r\n        GROUP BY subid\r\n    ) t2 ON t1.subid = t2.subid AND t1.createddate = t2.maxdate\r\n) t ON t.subid = s.subid\r\nWHERE c.company_id IN (:companyId)\r\n  AND s.createddate BETWEEN :startDate and :endDate \r\n  AND c.consultantid =:id \r\nORDER BY t.createddate DESC", nativeQuery=true)
    public List<SubmissionDTO> getsalessubmissionreport(@Param(value="startDate") LocalDateTime var1, @Param(value="endDate") LocalDateTime var2, @Param(value="id") Long var3, List<Long> var4);

    @Query(value="SELECT v.company AS vendor,        u.fullname,        u.pseudoname,        c.consultantname,        COALESCE(t.createddate, s.createddate) AS createddate,        COALESCE(t.endclient, s.endclient) AS endclient,        COALESCE(t.implpartner, s.implpartner) AS implpartner,        COALESCE(t.position, s.position) AS position,        COALESCE(t.projectlocation, s.projectlocation) AS projectlocation,        s.status,        COALESCE(t.submissionrate, s.submissionrate) AS submissionrate,        s.updateddate,        s.substatus FROM submission s JOIN consultant_info c ON s.consultantid = c.consultantid JOIN users u ON u.userid = s.userid JOIN vendor v      ON ((:flg = 'sales' AND s.vendorid = v.id)       OR (:flg = 'Recruiting' AND s.implpartner = v.company)) LEFT JOIN (      SELECT t1.*      FROM submission_track t1      JOIN (          SELECT subid, MAX(createddate) AS max_created          FROM submission_track          GROUP BY subid      ) t2 ON t1.subid = t2.subid AND t1.createddate = t2.max_created ) t ON t.subid = s.subid WHERE c.company_id IN (:companyId)   AND s.createddate BETWEEN :startDate AND :endDate   AND v.id = :id   AND s.flg = :flg", nativeQuery=true)
    public List<SubmissionDTO> getRequirementsReport(@Param(value="startDate") LocalDateTime var1, @Param(value="endDate") LocalDateTime var2, @Param(value="id") Long var3, @Param(value="flg") String var4, @Param(value="companyId") List<Long> var5);

    @Query(value="SELECT COALESCE(t.createddate, s.createddate) AS createddate, c.consultantname, COALESCE(t.position, s.position) AS position, COALESCE(t.implpartner, s.implpartner) AS implpartner, COALESCE(t.endclient, s.endclient) AS endclient, v.company AS vendor, COALESCE(t.submissionrate, s.submissionrate) AS submissionrate, u.fullname, u.pseudoname, COALESCE(t.projectlocation, s.projectlocation) AS projectlocation, s.status, COALESCE(t.substatus, s.substatus) AS substatus FROM submission s LEFT JOIN (    SELECT t1.*    FROM submission_track t1    INNER JOIN (        SELECT subid, MAX(createddate) AS max_createddate        FROM submission_track        GROUP BY subid    ) t2 ON t1.subid = t2.subid AND t1.createddate = t2.max_createddate ) t ON t.subid = s.subid JOIN consultant_info c ON s.consultantid = c.consultantid JOIN users u ON u.userid = s.userid LEFT JOIN vendor v ON s.vendorid = v.id WHERE u.companyid IN (:companyId) AND c.company_id IN (:companyId) AND s.createddate BETWEEN :startDate AND :endDate AND s.userid = :id ORDER BY t.createddate DESC", nativeQuery=true)
    public List<SubmissionDTO> getsalessubmissionreportForEmployee(@Param(value="startDate") LocalDateTime var1, @Param(value="endDate") LocalDateTime var2, @Param(value="id") Long var3, @Param(value="companyId") List<Long> var4);

    @Query(value="SELECT \r\n    COALESCE(t.interviewno, i.interviewno) AS interviewno,\r\n    v.company AS vendor,\r\n    i.flg,\r\n    s.endclient,\r\n    c.consultantid AS consid,\r\n    c.consultantname AS name,\r\n    COALESCE(t.interview_date, i.interview_date) AS interview_date,\r\n    COALESCE(t.round, i.round) AS round,\r\n    COALESCE(t.mode, i.mode) AS mode,\r\n    s.createddate,\r\n    u.userid,\r\n    u.fullname,\r\n    u.pseudoname,\r\n    COALESCE(t.interview_status, i.interview_status) AS interview_status,\r\n    COALESCE(t.time_zone, i.time_zone) AS time_zone,\r\n    i.id AS intrid,\r\n    s.subid\r\nFROM interview i\r\nJOIN submission s \r\n    ON i.submissionid = s.subid\r\nLEFT JOIN (\r\n    SELECT t.*\r\n    FROM interview_track t\r\n    JOIN (\r\n        SELECT interviewno, MAX(trckid) AS max_trckid\r\n        FROM interview_track\r\n        GROUP BY interviewno\r\n    ) latest\r\n      ON t.interviewno = latest.interviewno\r\n     AND t.trckid = latest.max_trckid\r\n) t \r\n    ON t.interviewno = i.interviewno  \r\nJOIN consultant_info c \r\n    ON s.consultantid = c.consultantid\r\nJOIN users u \r\n    ON i.addedby = u.userid\r\nLEFT JOIN vendor v \r\n    ON s.vendorid = v.id\r\nWHERE c.company_id IN (:companyId)\r\n  AND i.createddate BETWEEN :startDate and :endDate\r\n  AND c.consultantid = :id\r\nORDER BY i.updateddate DESC", nativeQuery=true)
    public List<ListInterview> getInterviewDropdown(@Param(value="startDate") LocalDateTime var1, @Param(value="endDate") LocalDateTime var2, @Param(value="id") Long var3, List<Long> var4);

    @Query(value="SELECT \r\n    COALESCE(t.interviewno, i.interviewno) AS interviewno,\r\n    v.company AS vendor,\r\n    i.flg,\r\n    s.endclient,\r\n    c.consultantid AS consid,\r\n    c.consultantname AS name,\r\n    COALESCE(t.interview_date, i.interview_date) AS interview_date,\r\n    COALESCE(t.round, i.round) AS round,\r\n    COALESCE(t.mode, i.mode) AS mode,\r\n    s.createddate,\r\n    u.userid,\r\n    u.fullname,\r\n    u.pseudoname,\r\n    COALESCE(t.interview_status, i.interview_status) AS interview_status,\r\n    COALESCE(t.time_zone, i.time_zone) AS time_zone,\r\n    i.id AS intrid,\r\n    s.subid\r\nFROM interview i\r\nJOIN submission s ON i.submissionid = s.subid\r\nJOIN vendor v ON s.vendorid = v.id\r\nJOIN consultant_info c ON s.consultantid = c.consultantid\r\nJOIN users u ON i.addedby = u.userid\r\nLEFT JOIN (\r\n    SELECT t1.*\r\n    FROM interview_track t1\r\n    JOIN (\r\n        SELECT interviewno, MAX(trckid) AS max_trckid\r\n        FROM interview_track\r\n        GROUP BY interviewno\r\n    ) t2 ON t1.interviewno = t2.interviewno AND t1.trckid = t2.max_trckid\r\n) t ON t.interviewno = i.interviewno\r\nWHERE i.createddate BETWEEN :startDate and :endDate\r\n  AND i.flg = :flg\r\n  AND v.id = :id\r\nORDER BY i.updateddate DESC", nativeQuery=true)
    public List<ListInterview> getInterviewsPopupForVendor(@Param(value="startDate") LocalDateTime var1, @Param(value="endDate") LocalDateTime var2, @Param(value="id") Long var3, @Param(value="flg") String var4);

    @Query(value="SELECT COALESCE(t.interviewno, i.interviewno) AS interviewno, v.company AS vendor, i.flg, s.endclient, c.consultantid AS consid, c.consultantname AS name, COALESCE(t.interview_date, i.interview_date) AS interview_date, COALESCE(t.round, i.round) AS round, COALESCE(t.mode, i.mode) AS mode, s.createddate, u.userid, u.fullname, u.pseudoname, COALESCE(t.interview_status, i.interview_status) AS interview_status, COALESCE(t.time_zone, i.time_zone) AS time_zone, i.id AS intrid, s.subid FROM interview i JOIN submission s ON i.submissionid = s.subid LEFT JOIN (    SELECT t.*    FROM interview_track t    JOIN (SELECT interviewno, MAX(trckid) AS max_trckid FROM interview_track GROUP BY interviewno) latest      ON t.interviewno = latest.interviewno AND t.trckid = latest.max_trckid ) t ON t.id = i.id JOIN consultant_info c ON s.consultantid = c.consultantid JOIN users u ON i.addedby = u.userid LEFT JOIN vendor v ON s.vendorid = v.id WHERE u.companyid IN (:companyId)   AND c.company_id IN (:companyId)   AND i.createddate BETWEEN :startDate AND :endDate   AND i.addedby = :id   AND i.flg != 'domrecruiting' ORDER BY i.updateddate DESC", nativeQuery=true)
    public List<ListInterview> getInterviewDropdownForEmployee(@Param(value="startDate") LocalDateTime var1, @Param(value="endDate") LocalDateTime var2, @Param(value="id") Long var3, @Param(value="companyId") List<Long> var4);

    @Query(value="SELECT c.consultantno, c.availabilityforinterviews, c.currentlocation, c.companyname, c.consultantemail, c.consultantname, c.contactnumber, c.createddate, c.experience, c.linkedin, c.projectavailabity, c.ratetype, c.relocatother, c.relocation, c.university, c.yop, c.hourlyrate, c.position, t.technologyarea, v.visa_status FROM consultant_info c LEFT JOIN technologies t ON t.id = c.techid LEFT JOIN visa v ON v.id = c.visa_status LEFT JOIN users u ON u.userid = c.addedby WHERE c.consultantflg = :flg   AND u.userid = :userid   AND c.company_id IN (:companyId)   AND c.createddate BETWEEN :startDate AND :endDate ORDER BY c.updateddate DESC", nativeQuery=true)
    public List<ConsultantDTO> recruiterLeads(@Param(value="flg") String var1, @Param(value="userid") long var2, @Param(value="startDate") LocalDateTime var4, @Param(value="endDate") LocalDateTime var5, @Param(value="companyId") List<Long> var6);

    @Query(value="select c.availabilityforinterviews, c.currentlocation, c.companyname,c.consultantemail,c.consultantname,c.contactnumber\r\n, c.createddate,c.experience,c.linkedin,c.projectavailabity,\r\nc.ratetype,c.relocatother,c.relocation,c.university,\r\nc.yop,c.hourlyrate,c.position, t.technologyarea,v.visa_status from consultant_info c, technologies t, visa v,users u \r\nwhere \r\nt.id = c.techid and c.company_id in (:companyId) and u.companyid in (:companyId) and \r\nv.id = c.visa_status and  u.userid=c.addedby and c.consultantflg='sales' and  c.isfrompre_sales = 1 and u.userid = :userid  and (c.createddate BETWEEN :startDate and :endDate or c.updateddate BETWEEN :startDate and :endDate) order by c.updateddate desc", nativeQuery=true)
    public List<ConsultantDTO> sourcingLeadsWithFlag(@Param(value="userid") long var1, @Param(value="startDate") LocalDateTime var3, @Param(value="endDate") LocalDateTime var4, List<Long> var5);

    @Query(value="select c.availabilityforinterviews, c.currentlocation, c.companyname,c.consultantemail,c.consultantname,c.contactnumber\r\n, c.createddate,c.experience,c.linkedin,c.projectavailabity,\r\nc.ratetype,c.relocatother,c.relocation,c.university,\r\nc.yop,c.hourlyrate,c.position, t.technologyarea,v.visa_status from consultant_info c, technologies t, visa v,users u \r\nwhere \r\nt.id = c.techid and c.company_id in (:companyId) and u.companyid in (:companyId) and \r\nv.id = c.visa_status and  u.userid=c.addedby and c.consultantflg=:flg and c.status=:status and u.userid = :userid and (c.createddate BETWEEN :startDate and :endDate or c.updateddate BETWEEN :startDate and :endDate) order by c.updateddate desc", nativeQuery=true)
    public List<ConsultantDTO> sourcingLeads(@Param(value="status") String var1, @Param(value="flg") String var2, @Param(value="userid") long var3, @Param(value="startDate") LocalDateTime var5, @Param(value="endDate") LocalDateTime var6, List<Long> var7);

    @Query(value="SELECT category_skill, COUNT(vendor) AS vendorcount FROM tbl_rec_requirement WHERE date(posted_on) BETWEEN :startDate AND :endDate AND category_skill IN (:category) GROUP BY category_skill", nativeQuery=true)
    public Page<Tbl_rec_requirementDTO> reqJobCategoryCount(String var1, String var2, String[] var3, Pageable var4);

    @Query(value="SELECT category_skill, COUNT(vendor) AS vendorcount FROM tbl_rec_requirement WHERE date(posted_on) BETWEEN :startDate AND :endDate AND category_skill IN (:category) GROUP BY category_skill", nativeQuery=true)
    public List<Tbl_rec_requirementDTO> reqJobCategoryCount(String var1, String var2, String[] var3);

    @Query(value="SELECT  u.source, u.job_source,  u.category_skill, u.posted_on, u.job_title, u.isexist,  u.job_location, u.Employment_type, u.email, u.phone, u.vendor, u.end_client, u.duration \tFROM tbl_rec_requirement u  WHERE u.Employment_type!='Full-time, Contract'AND u.category_skill = :flag AND date(u.posted_on) between :startDate AND :endDate ", nativeQuery=true)
    public Page<Tbl_rec_requirementDTO> reqJobCategoryCountPopup(String var1, String var2, String var3, Pageable var4);

    @Query(value="SELECT category_skill FROM tbl_rec_requirement  GROUP BY category_skill ORDER BY category_skill asc", nativeQuery=true)
    public List<String> getAllCategorys();

    @Query(nativeQuery=true, value="SELECT \r\n    SUM(CASE \r\n        WHEN i.interview_status = 'Hold' AND DATE_FORMAT(i.createddate, '%Y-%m-%d') BETWEEN :startdate AND :enddate \r\n        THEN 1 \r\n        ELSE 0 \r\n    END) AS onhold,\r\n    SUM(CASE \r\n        WHEN i.interview_status = 'Rejected' AND DATE_FORMAT(i.createddate, '%Y-%m-%d') BETWEEN :startdate AND :enddate \r\n        THEN 1 \r\n        ELSE 0 \r\n    END) AS rejected,\r\n    SUM(CASE \r\n        WHEN i.interview_status = 'BackOut' AND DATE_FORMAT(i.createddate, '%Y-%m-%d') BETWEEN :startdate AND :enddate \r\n        THEN 1 \r\n        ELSE 0 \r\n    END) AS backout,\r\n    SUM(CASE \r\n        WHEN i.interview_status = 'Schedule' AND DATE_FORMAT(i.createddate, '%Y-%m-%d') BETWEEN :startdate AND :enddate \r\n        THEN 1 \r\n        ELSE 0 \r\n    END) AS schedule,\r\n    SUM(CASE \r\n        WHEN i.interview_status = 'selected' AND DATE_FORMAT(i.createddate, '%Y-%m-%d') BETWEEN :startdate AND :enddate \r\n        THEN 1 \r\n        ELSE 0 \r\n    END) AS selected,\r\n    SUM(CASE \r\n        WHEN i.interview_status = 'closed' AND DATE_FORMAT(i.createddate, '%Y-%m-%d') BETWEEN :startdate AND :enddate \r\n        THEN 1 \r\n        ELSE 0 \r\n    END) AS closed,\r\n    SUM(CASE \r\n        WHEN i.interview_status = 'OnBoarded' AND DATE_FORMAT(i.createddate, '%Y-%m-%d') BETWEEN :startdate AND :enddate \r\n        THEN 1 \r\n        ELSE 0 \r\n    END) AS onboarded,\r\n    COUNT(DISTINCT CASE \r\n        WHEN DATE_FORMAT(s.createddate, '%Y-%m-%d') BETWEEN :startdate AND :enddate \r\n        THEN s.subid \r\n        ELSE NULL \r\n    END) AS submission\r\nFROM \r\n    users u\r\n    JOIN consultant_info c ON u.userid = c.addedby\r\n    JOIN submission s ON c.consultantid = s.consultantid\r\n    LEFT JOIN interview i ON s.subid = i.submissionid\r\nWHERE \r\n    u.userid = :userid")
    public List<ConsultantReportDTO> getRec_RecruiremntReport(LocalDate var1, LocalDate var2, Long var3);

    @Query(nativeQuery=true, value="select i.time_zone,i.interviewno,c.consultantname as name,i.createddate,i.interview_date, i.round, i.mode, (select  v.company from vendor v where s.vendorid=v.id) as vendor, s.endclient, s.createddate as submitteddate,\r\n v.pseudoname, i.interview_status, i.id,s.subid from  \r\n    consultant_info c \r\n    JOIN users u ON c.addedby = u.userid \r\n    join users v on c.updatedbyid=v.userid\r\n    JOIN submission s ON c.consultantid = s.consultantid \r\n    LEFT JOIN interview i ON s.subid = i.submissionid\r\nWHERE \r\n    u.department = 'Consultant' and u.designation='Consultant'\r\n    AND u.userid = :id and i.interview_status = :status\r\nAND date_format(i.createddate,'%Y-%m-%d') BETWEEN :startDate AND :endDate\r\n")
    public List<ListInterview> reportDrillDownSearch(@Param(value="status") List<String> var1, @Param(value="startDate") LocalDate var2, @Param(value="endDate") LocalDate var3, @Param(value="id") Long var4);

    @Query(nativeQuery=true, value="SELECT distinct s.createddate as createddate,c.consultantname, s.position as position, s.implpartner as implpartner\r\n, s.endclient as endclient, \r\nv.company as vendor,\r\ns.submissionrate as submissionrate,s.projectlocation as projectlocation\r\n,w.pseudoname as submittedby,s.substatus    \r\nFROM \r\n    consultant_info c \r\n    JOIN users u ON c.addedby = u.userid \r\n    join users w on c.updatedbyid=w.userid\r\n    JOIN submission s ON c.consultantid = s.consultantid \r\n    join vendor v on s.vendorid=v.id\r\n    LEFT JOIN interview i ON s.subid = i.submissionid\r\nWHERE \r\n    u.department = 'Consultant' and u.designation='Consultant'\r\n    AND u.userid = :id and date_format(s.createddate,'%Y-%m-%d') between :startDate and :endDate\r\n\r\n")
    public List<SubmissionDTO> employeeSubPopup(@Param(value="startDate") LocalDate var1, @Param(value="endDate") LocalDate var2, @Param(value="id") Long var3);

    @Query(nativeQuery=true, value="SELECT u.userid as userid,c.consultantid AS id, c.consultantname as consultantname,\r\n       (SELECT COUNT(*)\r\n       FROM appliedjobs aj\r\n       JOIN users u ON u.userid = aj.applied_by join tbl_rec_requirement trr on aj.jobid=trr.id\r\n        WHERE u.userid = c.addedby and DATE_FORMAT(aj.createddate, '%Y-%m-%d') BETWEEN :startDate AND :endDate) AS apply_count,\r\n       (SELECT COUNT(*) \r\n        FROM interview i \r\n        JOIN submission sub ON i.submissionid = sub.subid \r\n        WHERE sub.consultantid = c.consultantid \r\n          AND i.interview_status = 'BackOut' \r\n          AND DATE_FORMAT(i.createddate, '%Y-%m-%d') BETWEEN :startDate AND :endDate) AS backout,\r\n       (SELECT COUNT(*) \r\n        FROM interview i \r\n        JOIN submission sub ON i.submissionid = sub.subid \r\n        WHERE sub.consultantid = c.consultantid \r\n          AND i.interview_status = 'OnBoarded' \r\n          AND DATE_FORMAT(i.createddate, '%Y-%m-%d') BETWEEN :startDate AND :endDate) AS onboarded,\r\n       (SELECT COUNT(*) \r\n        FROM interview i \r\n        JOIN submission sub ON i.submissionid = sub.subid \r\n        WHERE sub.consultantid = c.consultantid \r\n          AND i.interview_status = 'Schedule' \r\n          AND DATE_FORMAT(i.createddate, '%Y-%m-%d') BETWEEN :startDate AND :endDate) AS schedule,\r\n       (SELECT COUNT(*) \r\n        FROM interview i \r\n        JOIN submission sub ON i.submissionid = sub.subid \r\n        WHERE sub.consultantid = c.consultantid \r\n          AND i.interview_status = 'Rejected' \r\n          AND DATE_FORMAT(i.createddate, '%Y-%m-%d') BETWEEN :startDate AND :endDate) AS rejected,\r\n       (SELECT COUNT(*) \r\n        FROM interview i \r\n        JOIN submission sub ON i.submissionid = sub.subid \r\n        WHERE sub.consultantid = c.consultantid \r\n          AND i.interview_status = 'Hold' \r\n          AND DATE_FORMAT(i.createddate, '%Y-%m-%d') BETWEEN :startDate AND :endDate) AS onhold,\r\n       (SELECT COUNT(*) \r\n        FROM interview i \r\n        JOIN submission sub ON i.submissionid = sub.subid \r\n        WHERE sub.consultantid = c.consultantid \r\n          AND i.interview_status = 'Selected' \r\n          AND DATE_FORMAT(i.createddate, '%Y-%m-%d') BETWEEN :startDate AND :endDate) AS selected,\r\n       (SELECT COUNT(*) \r\n        FROM interview i \r\n        JOIN submission sub ON i.submissionid = sub.subid \r\n        WHERE sub.consultantid = c.consultantid \r\n          AND i.interview_status = 'Closed' \r\n          AND DATE_FORMAT(i.createddate, '%Y-%m-%d') BETWEEN :startDate AND :endDate) AS closed,\r\n       (SELECT COUNT(*) \r\n        FROM submission sub \r\n        WHERE sub.consultantid = c.consultantid\r\n          AND sub.substatus = 'Submitted'\r\n          AND DATE_FORMAT(sub.createddate, '%Y-%m-%d') BETWEEN :startDate AND :endDate) AS submission\r\nFROM users u\r\nJOIN consultant_info c ON u.userid = c.addedby\r\nWHERE c.company_id in (:companyId) AND u.department = 'Consultant' AND u.designation = 'Consultant' AND u.status='Active' AND c.status = 'Active' \r\nGROUP BY c.consultantid\r\nORDER BY c.consultantname\r\n")
    public List<ConsultantReportDTO> getAllEmployeeReport(@Param(value="startDate") LocalDate var1, @Param(value="endDate") LocalDate var2, List<Long> var3);

    @Query(nativeQuery=true, value="SELECT \r\ndistinct s.createddate as createddate,\r\nc.consultantname\r\n, s.position as position, s.implpartner as implpartner\r\n\t\t\t, s.endclient as endclient, \r\n\t\t\tv.company as vendor,\r\n\t\t\ts.submissionrate as submissionrate,s.projectlocation as projectlocation\r\n        #,w.pseudoname as submittedby\r\n        ,s.substatus    \r\n\t\t\tFROM \r\n\t\t\t     users u\r\n\t\t\t    JOIN consultant_info c ON  u.userid = c.con_registration_id  \r\n\t\t\t  #  join users w on c.updatedbyid=w.userid\r\n\t\t\t    JOIN submission s ON c.consultantid = s.consultantid \r\n\t\t\t    join vendor v on s.vendorid=v.id\r\n\t\t\t   # LEFT JOIN interview i ON s.subid = i.submissionid\r\n\t\t\tWHERE \r\n\t\t\tu.userid=:id and\r\n            u.department = 'Consultant' and c.company_id in (:companyId) and u.designation='Consultant'  and s.substatus='Submitted' and  date_format(s.createddate,'%Y-%m-%d') between :startDate and :endDate order by createddate\r\n ")
    public List<SubmissionDTO> getEmployeeSubmissionPopups(@Param(value="startDate") LocalDate var1, @Param(value="endDate") LocalDate var2, @Param(value="id") Long var3, List<Long> var4);

    @Query(nativeQuery=true, value="select u.fullname,t.vendor , a.createddate as createddate, a.jobid,t.id,a.applied_by,t.posted_on ,t.job_title,t.job_description,t.job_location,\r\nt.category_skill,t.job_source,t.Employment_type,t.source,t.isexist from  tbl_rec_requirement t, appliedjobs a, users u where u.companyid in (:companyId) and a.jobid=t.id AND a.applied_by=u.userid and a.jobid=t.id\r\nand DATE_FORMAT(a.createddate, '%Y-%m-%d') BETWEEN :startDate AND :endDate and a.applied_by=:id ")
    public List<AppliedListDTO> getEmployeeJobApplyPopup(@Param(value="startDate") LocalDate var1, @Param(value="endDate") LocalDate var2, @Param(value="id") Long var3, List<Long> var4);

    @Query(nativeQuery=true, value="select i.interviewno, (select  v.company from vendor v where s.vendorid=v.id) as vendor,i.flg, s.endclient,c.consultantid as consid, c.consultantname as name, i.interview_date, i.round, i.mode,  s.createddate,\r\nu.userid, u.fullname,u.pseudoname, i.interview_status, i.time_zone, i.id as intrid, s.subid\r\nfrom interview i, consultant_info c, submission s , users u , users w where c.company_id in (:companyId) and i.submissionid = s.subid and u.userid=c.con_registration_id and\r\ns.consultantid = c.consultantid and  i.addedby = w.userid and date_format(i.createddate,'%Y-%m-%d') between :startDate and :endDate and u.userid=:id and i.interview_status=:status order by i.updateddate desc")
    public List<ListInterview> getEmployeeInterviewStatPopup(@Param(value="startDate") LocalDate var1, @Param(value="endDate") LocalDate var2, @Param(value="id") Long var3, @Param(value="status") String var4, List<Long> var5);

    @Query(value="SELECT v.company AS vendor, r.reqnumber, r.createddate, r.jobtitle, r.location, r.employmenttype,  r.status,  r.id AS requirementid,u.pseudoname  FROM\r\n rec_requirements r, vendor v, users u WHERE u.userid=r.addedby AND v.id = r.vendorid and r.createddate between :startDate and :endDate and r.flg=:flg and v.id=:vendorId", nativeQuery=true)
    public List<RequirementDTO> requirementPopUp(@Param(value="startDate") LocalDate var1, @Param(value="endDate") LocalDate var2, Long var3, @Param(value="flg") String var4);

    @Query(value="SELECT c.consultantname as consultantname ,u.fullname as fullname ,rq.job_title,rc.comment_id,rc.createddate,rc.updateddate,rc.commented_by,rc.consultant_id,rc.issue_type,rc.req_id,rc.comment FROM req_comments rc join consultant_info c on c.consultantid=rc.consultant_id join tbl_rec_requirement rq on rq.id=rc.req_id \r\njoin users u on u.userid=rc.commented_by WHERE date(rc.createddate) BETWEEN :startDate AND :endDate  ", nativeQuery=true)
    public Page<ReqCommentDTO> reqCommentReportWithPagination(Pageable var1, @Param(value="startDate") LocalDate var2, @Param(value="endDate") LocalDate var3);

    @Query(value="SELECT c.consultantname AS consultantname, u.fullname AS fullname, rq.job_title, rc.comment_id, rc.createddate, rc.updateddate, rc.commented_by, rc.consultant_id, rc.issue_type, rc.req_id, rc.comment FROM req_comments rc JOIN consultant_info c ON c.consultantid = rc.consultant_id JOIN tbl_rec_requirement rq ON rq.id = rc.req_id JOIN users u ON u.userid = rc.commented_by WHERE DATE(rc.createddate) BETWEEN :startDate AND :endDate AND (c.consultantname LIKE CONCAT('%', :keyword, '%') OR rq.job_title LIKE CONCAT('%', :keyword, '%') OR CAST(rc.commented_by AS CHAR) LIKE CONCAT('%', :keyword, '%') OR u.fullname LIKE CONCAT('%', :keyword, '%') OR CAST(rc.createddate AS CHAR) LIKE CONCAT('%', :keyword, '%') OR CAST(rc.updateddate AS CHAR) LIKE CONCAT('%', :keyword, '%'))", nativeQuery=true)
    public Page<ReqCommentDTO> reqCommentReportWithSearching(Pageable var1, @Param(value="startDate") LocalDate var2, @Param(value="endDate") LocalDate var3, @Param(value="keyword") String var4);

    @Query(value="SELECT c.consultantname as consultantname ,u.fullname as fullname ,rq.job_title,rc.comment_id,rc.createddate,rc.updateddate,rc.commented_by,rc.consultant_id,rc.issue_type,rc.req_id,rc.comment FROM req_comments rc join consultant_info c on c.consultantid=rc.consultant_id join tbl_rec_requirement rq on rq.id=rc.req_id \r\njoin users u on u.userid=rc.commented_by WHERE c.company_id in (:companyId) AND date(rc.createddate) BETWEEN :startDate AND :endDate  ", nativeQuery=true)
    public List<ReqCommentDTO> reqCommentReport(@Param(value="startDate") LocalDate var1, @Param(value="endDate") LocalDate var2, List<Long> var3);
}

