/*
 * Decompiled with CFR 0.152.
 */
package com.narvee.repository;

import com.narvee.dto.BanterReportDTO;
import com.narvee.entity.CallRecordReport;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface CallRecordRepository
extends JpaRepository<CallRecordReport, Long> {
    @Query(nativeQuery=true, value="select banterno from users  where banterno!='null' and banterno!='' and status='Active'")
    public List<String> banternumber();

    @Query(nativeQuery=true, value="SELECT\r\n    u.banterno AS `Banter_No`,\r\n    u.fullname AS `Emp_Name`,\r\n    u.pseudoname AS `Pseudo_Name`,\r\n    u.department AS `Department`,\r\n    SUM(CASE WHEN crr.direction = 'out' AND crr.call_type IN ('dialed', 'answered', 'hangup', 'missed', 'voicemail') THEN 1 ELSE 0 END) AS `Dialled`,\r\n    ROUND(SUM(CASE WHEN crr.direction = 'out' AND crr.call_type IN ('dialed', 'answered', 'hangup', 'missed', 'voicemail') THEN TIMESTAMPDIFF(SECOND, crr.start_time, crr.end_time) / 60 ELSE 0 END)) AS `Minutes_Dialled`,\r\n    SUM(CASE WHEN crr.direction = 'in' AND crr.call_type = 'answered' THEN 1 ELSE 0 END) AS `Answered`,\r\n    ROUND(SUM(CASE WHEN crr.direction = 'in' AND crr.call_type = 'answered' THEN TIMESTAMPDIFF(SECOND, crr.start_time, crr.end_time) / 60 ELSE 0 END)) AS `Minutes_Answered`,\r\n    SUM(CASE WHEN crr.direction = 'in' AND crr.call_type = 'missed' THEN 1 ELSE 0 END) AS `Missed`,\r\n    ROUND((SUM(CASE WHEN crr.direction = 'out' AND crr.call_type IN ('dialed', 'answered', 'hangup', 'missed', 'voicemail') THEN TIMESTAMPDIFF(SECOND, crr.start_time, crr.end_time) / 60 ELSE 0 END) +\r\n          SUM(CASE WHEN crr.direction = 'in' AND crr.call_type = 'answered' THEN TIMESTAMPDIFF(SECOND, crr.start_time, crr.end_time) / 60 ELSE 0 END))) AS `Total_Min`,\r\n    (DATEDIFF(:enddate, :startdate)) * 60 AS `Target`,\r\n    ROUND((SUM(CASE WHEN crr.direction = 'out' AND crr.call_type IN ('dialed', 'answered', 'hangup', 'missed', 'voicemail') THEN TIMESTAMPDIFF(SECOND, crr.start_time, crr.end_time) / 60 ELSE 0 END) +\r\n           SUM(CASE WHEN crr.direction = 'in' AND crr.call_type = 'answered' THEN TIMESTAMPDIFF(SECOND, crr.start_time, crr.end_time) / 60 ELSE 0 END)) / ((DATEDIFF(:enddate, :startdate)) * 60) * 100) AS `Percentage`\r\nFROM\r\n    users u\r\nLEFT JOIN\r\n    call_record_report crr ON u.banterno = crr.call_from AND date(crr.created_date) BETWEEN :startdate AND :enddate\r\nWHERE\r\n    u.department = :flag  and u.status='active' and u.banterno!='null'\r\nGROUP BY\r\n    u.pseudoname, u.banterno, u.fullname, u.department, u.companyid in (:companyId)\r\nORDER BY\r\n    `Banter_No` DESC")
    public List<BanterReportDTO> banterReport(LocalDate var1, LocalDate var2, String var3, List<Long> var4);

    @Query(nativeQuery=true, value="SELECT\r\n    u.banterno AS `Banter_No`,\r\n    u.fullname AS `Emp_Name`,\r\n    u.pseudoname AS `Pseudo_Name`,\r\n    u.department AS `Department`,\r\n    SUM(CASE WHEN crr.direction = 'out' and crr.call_type in ('dialed','answered','hangup','missed','voicemail') THEN 1 ELSE 0 END) AS `Dialled`,\r\n    round(SUM(CASE WHEN crr.direction = 'out' and crr.call_type in ('dialed','answered','hangup','missed','voicemail') then TIMESTAMPDIFF(SECOND, crr.start_time, crr.end_time)/60 ELSE 0 END)) AS `Minutes_Dialled`,\r\n     SUM(CASE WHEN crr.direction = 'in' and crr.call_type in ('answered') THEN 1 ELSE 0 END) AS `answered`,\r\n    round(SUM(CASE WHEN crr.direction = 'in' and crr.call_type in ('answered') then TIMESTAMPDIFF(SECOND, crr.start_time, crr.end_time)/60 ELSE 0 END))AS `Minutes_answered`,\r\n     SUM(CASE WHEN crr.direction = 'in' and crr.call_type='missed' THEN 1 ELSE 0 END) AS `Missed`,\r\n    round((SUM(CASE WHEN crr.direction = 'out' AND crr.call_type in ('dialed','answered','hangup','missed','voicemail') THEN TIMESTAMPDIFF(SECOND, crr.start_time, crr.end_time)/60 ELSE 0 END) +\r\n    SUM(CASE WHEN crr.direction = 'in' AND crr.call_type='answered' THEN TIMESTAMPDIFF(SECOND, crr.start_time, crr.end_time)/60 ELSE 0 END))) AS `Total_Min`,\r\n    (DATEDIFF(date_format(:enddate,'%Y-%m-%d'),date_format(:startdate,'%Y-%m-%d')))*60 AS `Target`,\r\n    \r\n     round((SUM(CASE WHEN crr.direction = 'out' AND crr.call_type in ('dialed','answered','hangup','missed','voicemail') then TIMESTAMPDIFF(SECOND, crr.start_time, crr.end_time)/60 ELSE 0 END) \r\n\t+SUM(CASE WHEN crr.direction = 'in' AND crr.call_type='answered' THEN TIMESTAMPDIFF(SECOND, crr.start_time, crr.end_time)/60 ELSE 0 END)) / ((DATEDIFF(:enddate, :startdate)) * 60) * 100) AS `Percentage`\r\n      \r\nFROM\r\n    users u\r\nJOIN\r\n    call_record_report crr ON u.banterno = crr.call_from\r\nWHERE\r\n    u.department = :flag and date(crr.created_date) between :startdate and :enddate and u.userid=:userid\r\nGROUP BY\r\n    u.pseudoname, u.banterno, u.fullname, u.department\r\nORDER BY\r\n    `Banter_No` DESC")
    public List<BanterReportDTO> individualbanterReport(LocalDate var1, LocalDate var2, String var3, Long var4);

    @Query(value="select date_add(max(date_format(created_date,'%Y-%m-%d')), interval 1 day) as fromday from call_record_report", nativeQuery=true)
    public LocalDateTime maxdate();

    @Query(value="select date_add(max(date_format(created_date,'%Y-%m-%d')), interval 1 day) as fromday from call_record_report", nativeQuery=true)
    public String maxdates();

    @Query(nativeQuery=true, value="select * from call_record_report where created_date=:cdate and start_time=:stime and end_time=:etime and billmin=:bmin and call_from=:cfrom and call_to=:cto and call_type=:ctype and caller_id=:cid and direction=:dir and duration=:dur")
    public List<CallRecordReport> findduplicatedata(LocalDateTime var1, LocalDateTime var2, LocalDateTime var3, Integer var4, String var5, String var6, String var7, String var8, String var9, Integer var10);
}

