/*
 * Decompiled with CFR 0.152.
 */
package com.narvee.controller;

import com.narvee.commons.RestAPIResponse;
import com.narvee.dto.DateSearcherDto;
import com.narvee.dto.ReqCommentRequest;
import com.narvee.service.IReportService;
import com.narvee.service.RequestDTO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ReportsController {
    private static final Logger logger = LoggerFactory.getLogger(ReportsController.class);
    @Autowired
    private IReportService service;

    @RequestMapping(value={"/creport/{companyId}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> consultantReport(@RequestBody DateSearcherDto dateSearcherDto, @PathVariable String companyId, @RequestHeader(value="Authorization") String token) {
        logger.info("!!! inside class: ReportController, method : consultantReport");
        List consutantReport = this.service.consutantReport(dateSearcherDto, companyId, token);
        return new ResponseEntity((Object)new RestAPIResponse("success", "Consultant consultantReport", (Object)consutantReport), HttpStatus.OK);
    }

    @RequestMapping(value={"/sourcingreport/{companyId}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> preSalesReport(@RequestBody DateSearcherDto dateSearcherDto, @PathVariable String companyId, @RequestHeader(value="Authorization") String token) {
        List reportVal = this.service.sourcingReport(dateSearcherDto, companyId, token);
        return new ResponseEntity((Object)new RestAPIResponse("success", "presales sourcing Report Fetched", (Object)reportVal), HttpStatus.OK);
    }

    @RequestMapping(value={"/popup/{companyId}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> popUp(@RequestBody DateSearcherDto dateSearcherDto, @PathVariable String companyId, @RequestHeader(value="Authorization") String token) {
        logger.info("!!! inside class: ReportController, method : popUp");
        List reportDrillDown = this.service.reportDrillDownsearch(dateSearcherDto, companyId, token);
        return new ResponseEntity((Object)new RestAPIResponse("success", "Consultant consultantReport", (Object)reportDrillDown), HttpStatus.OK);
    }

    @RequestMapping(value={"/popupSub/{companyId}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> popupSub(@RequestBody DateSearcherDto dateSearcherDto, @PathVariable String companyId, @RequestHeader(value="Authorization") String token) {
        logger.info("!!! inside class: ReportController, method : popupSub");
        List reportDrillDown = this.service.getsalessubmission(dateSearcherDto, companyId, token);
        return new ResponseEntity((Object)new RestAPIResponse("success", "Consultant consultantReport", (Object)reportDrillDown), HttpStatus.OK);
    }

    @RequestMapping(value={"/popupInt/{companyId}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> popupInt(@RequestBody DateSearcherDto dateSearcherDto, @PathVariable String companyId, @RequestHeader(value="Authorization") String token) {
        logger.info("!!! inside class: ReportController, method : popupInt");
        List reportDrillDown = this.service.getInterviewDropdown(dateSearcherDto, companyId, token);
        return new ResponseEntity((Object)new RestAPIResponse("success", "Consultant consultantReport", (Object)reportDrillDown), HttpStatus.OK);
    }

    @RequestMapping(value={"/recruiterleads/{companyId}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> recruiterleads(@RequestBody DateSearcherDto dateSearcherDto, @PathVariable String companyId, @RequestHeader(value="Authorization") String token) {
        logger.info("!!! inside class: ReportController, method : recruiterleads");
        List reportDrillDown = this.service.recruiterleads(dateSearcherDto, companyId, token);
        return new ResponseEntity((Object)new RestAPIResponse("success", "Consultant consultantReport", (Object)reportDrillDown), HttpStatus.OK);
    }

    @RequestMapping(value={"/sourceleads/{companyId}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> sourceleads(@RequestBody DateSearcherDto dateSearcherDto, @PathVariable String companyId, @RequestHeader(value="Authorization") String token) {
        logger.info("!!! inside class: ReportController, method : sourceleads");
        List reportDrillDown = this.service.sourceLeads(dateSearcherDto, companyId, token);
        return new ResponseEntity((Object)new RestAPIResponse("success", "Consultant consultantReport", (Object)reportDrillDown), HttpStatus.OK);
    }

    @PostMapping(value={"/getReqReport"})
    public ResponseEntity<RestAPIResponse> getReqReports(@RequestBody RequestDTO request) {
        logger.info("!!! inside class: ReportController, method : getReqReports");
        Page reports = this.service.reqJobCategoryCount(request);
        return new ResponseEntity((Object)new RestAPIResponse("success", "Reports fetched Successfully", (Object)reports), HttpStatus.OK);
    }

    @GetMapping(value={"/getCategorys"})
    public ResponseEntity<RestAPIResponse> getCategorys() {
        logger.info("!!! inside class: ReportController, method : getCategorys");
        List categorys = this.service.getAllCategorys();
        return new ResponseEntity((Object)new RestAPIResponse("success", "Categorys fetched Successfully", (Object)categorys), HttpStatus.OK);
    }

    @RequestMapping(value={"/individualEmployeeReport"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> employeeIndividualReport(@RequestBody DateSearcherDto dateSearcherDto) {
        logger.info("!!! inside class: ReportController, method : employeeIndividualReport");
        List consutantReport = this.service.employeeIndividualReport(dateSearcherDto);
        return new ResponseEntity((Object)new RestAPIResponse("success", "Consultant consultantReport", (Object)consutantReport), HttpStatus.OK);
    }

    @RequestMapping(value={"/employeeIntervStatusPopups"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> employeeIntervStatusPopups(@RequestBody DateSearcherDto dateSearcherDto) {
        logger.info("!!! inside class: ReportController, method : employeeIntervStatusPopups");
        List reportDrillDown = this.service.employeeIntervStatusPopups(dateSearcherDto);
        return new ResponseEntity((Object)new RestAPIResponse("success", "Consultant consultantReport", (Object)reportDrillDown), HttpStatus.OK);
    }

    @RequestMapping(value={"/employeeSubPopup"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> employeeSubPopup(@RequestBody DateSearcherDto dateSearcherDto) {
        logger.info("!!! inside class: ReportController, method : employeeSubPopup");
        List reportDrillDown = this.service.employeeSubPopup(dateSearcherDto);
        return new ResponseEntity((Object)new RestAPIResponse("success", "Consultant consultantReport", (Object)reportDrillDown), HttpStatus.OK);
    }

    @RequestMapping(value={"/allEmployeesReport/{companyId}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> allEmployeeReport(@RequestBody DateSearcherDto dateSearcherDto, @PathVariable String companyId, @RequestHeader(value="Authorization") String token) {
        logger.info("!!! inside class: ReportController, method : allEmployeeReport");
        List reportDrillDown = this.service.allEmployeesReport(dateSearcherDto, companyId, token);
        return new ResponseEntity((Object)new RestAPIResponse("success", "Employees Report", (Object)reportDrillDown), HttpStatus.OK);
    }

    @RequestMapping(value={"/employeeSubmissionPopup/{companyId}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> employeeSubmissionPopup(@RequestBody DateSearcherDto dateSearcherDto, @PathVariable String companyId, @RequestHeader(value="Authorization") String token) {
        logger.info("!!! inside class: ReportController, method : employeeSubmissionPopup");
        List reportDrillDown = this.service.getEmployeeSubmissionPopup(dateSearcherDto, companyId, token);
        return new ResponseEntity((Object)new RestAPIResponse("success", "Employee SubmissionPopup", (Object)reportDrillDown), HttpStatus.OK);
    }

    @RequestMapping(value={"/employeeJobApplyCount/{companyId}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> employeeJobApplyPopup(@RequestBody DateSearcherDto dateSearcherDto, @PathVariable String companyId, @RequestHeader(value="Authorization") String token) {
        logger.info("!!! inside class: ReportController, method : employeeJobApplyPopup");
        List reportDrillDown = this.service.getemployeeJobApplyPopup(dateSearcherDto, companyId, token);
        return new ResponseEntity((Object)new RestAPIResponse("success", "Employee employeeJobApplyPopup", (Object)reportDrillDown), HttpStatus.OK);
    }

    @RequestMapping(value={"/employeeInterviewStatPopups/{companyId}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> employeeInterviewStatPopups(@RequestBody DateSearcherDto dateSearcherDto, @PathVariable String companyId, @RequestHeader(value="Authorization") String token) {
        logger.info("!!! inside class: ReportController, method : employeeInterviewStatPopups");
        List reportDrillDown = this.service.getEmployeeInterviewStatPopups(dateSearcherDto, companyId, token);
        return new ResponseEntity((Object)new RestAPIResponse("success", "Employee interview stat popups", (Object)reportDrillDown), HttpStatus.OK);
    }

    @RequestMapping(value={"/reqPopups"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> getRequirement(@RequestBody DateSearcherDto dateSearcherDto) {
        logger.info("!!! inside class: ReportController, method : getRequirement");
        List reportreq = this.service.getrequirementPopUps(dateSearcherDto);
        return new ResponseEntity((Object)new RestAPIResponse("success", "req popups", (Object)reportreq), HttpStatus.OK);
    }

    @RequestMapping(value={"/ReqCommentsReport"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> reqommentReportWithPagination(@RequestBody ReqCommentRequest reqcommentResponse) {
        logger.info("!!! inside class: ReportController, method : reqommentReportWithPagination");
        return new ResponseEntity((Object)new RestAPIResponse("success", "Successfully fetched report with searching", (Object)this.service.reqCommentReportWithPagination(reqcommentResponse)), HttpStatus.OK);
    }

    @RequestMapping(value={"/CommentsReport/{companyId}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<RestAPIResponse> reqommentReport(@RequestBody ReqCommentRequest reqcommentResponse, @PathVariable String companyId, @RequestHeader(value="Authorization") String token) {
        logger.info("!!! inside class: ReportController, method : reqommentReport");
        return new ResponseEntity((Object)new RestAPIResponse("success", "Comments Reports fetched Successfully", (Object)this.service.reqCommentReport(reqcommentResponse, companyId, token)), HttpStatus.OK);
    }
}

