/*
 * Decompiled with CFR 0.152.
 */
package com.narvee.controller;

import com.narvee.commons.RestAPIResponse;
import com.narvee.dto.BestPerformer;
import com.narvee.dto.ReqCommentRequest;
import com.narvee.dto.ratingsDto;
import com.narvee.service.IRatingsService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rating"})
public class RatingController {
    final Logger logger = LoggerFactory.getLogger(RatingController.class);
    @Autowired
    private IRatingsService ratingsService;

    @PostMapping(value={"/saveRatings"})
    public ResponseEntity<RestAPIResponse> saveRatings(@RequestBody ratingsDto ratingsDto2) {
        this.logger.info("!!! inside class: RatingController, method : saveRatings");
        try {
            this.ratingsService.saveRatings(ratingsDto2);
            return new ResponseEntity((Object)new RestAPIResponse("Success", "saved"), HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new RestAPIResponse("Failed", "failed to save ratings"), HttpStatus.OK);
        }
    }

    @DeleteMapping(value={"/deleteRatings/{Id}"})
    public ResponseEntity<RestAPIResponse> deleteRatings(@PathVariable Long Id) {
        this.logger.info("!!! inside class: RatingController, method : deleteRatings");
        try {
            this.ratingsService.deleteRatings(Id.longValue());
            return new ResponseEntity((Object)new RestAPIResponse("Success", "deleted"), HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new RestAPIResponse("Failed", "failed to delete ratings"), HttpStatus.OK);
        }
    }

    @PostMapping(value={"/getRatings/{companyId}"})
    public ResponseEntity<RestAPIResponse> getRatingsBymanager(@RequestBody ReqCommentRequest commentRequest, @PathVariable String companyId) {
        this.logger.info("!!! inside class: RatingController, method : getRatingsBymanager");
        try {
            Page dto = this.ratingsService.getRatings(commentRequest, companyId);
            return new ResponseEntity((Object)new RestAPIResponse("Success", "fetched all ratings", (Object)dto), HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new RestAPIResponse("Failed", "failed to fetch ratings"), HttpStatus.OK);
        }
    }

    @GetMapping(value={"/getRatingsbyid/{id}"})
    public ResponseEntity<RestAPIResponse> getRatings(@PathVariable Long id) {
        this.logger.info("!!! inside class: RatingController, method : getRatings");
        try {
            ratingsDto dto = this.ratingsService.getRatingsById(id);
            return new ResponseEntity((Object)new RestAPIResponse("Success", "fetched all ratings", (Object)dto), HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new RestAPIResponse("Failed", "failed to fetch ratings"), HttpStatus.OK);
        }
    }

    @GetMapping(value={"/getTlsDropdown/{ManagerId}/{companyId}"})
    public ResponseEntity<RestAPIResponse> getTls(@PathVariable Long ManagerId, @PathVariable String companyId) {
        this.logger.info("!!! inside class: RatingController, method : getTls");
        List Tls = this.ratingsService.getTlsByManagerId(ManagerId, companyId);
        return new ResponseEntity((Object)new RestAPIResponse("Success", "fetched  Users", (Object)Tls), HttpStatus.OK);
    }

    @GetMapping(value={"/getExicutivesDropdown/{TL}"})
    public ResponseEntity<RestAPIResponse> getExicutives(@PathVariable Long TL) {
        this.logger.info("!!! inside class: RatingController, method : getExicutives");
        List exicitives = this.ratingsService.getUsersByTLid(TL);
        return new ResponseEntity((Object)new RestAPIResponse("Success", "fetched Users", (Object)exicitives), HttpStatus.OK);
    }

    @GetMapping(value={"/getBestPerformer/{ratingType}/{companyId}"})
    public ResponseEntity<RestAPIResponse> getExicutives(@PathVariable String ratingType, @PathVariable String companyId, @RequestHeader(value="Authorization") String token) {
        this.logger.info("!!! inside class: RatingController, method : getExicutives");
        BestPerformer BestPerformer2 = this.ratingsService.getBestPerformer(ratingType, companyId, token);
        return new ResponseEntity((Object)new RestAPIResponse("Success", "fetched Users", (Object)BestPerformer2), HttpStatus.OK);
    }
}

